/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.TooltipRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ExtendedGuiGraphics {
    private final GuiGraphics guiGraphics;
    private final MultiBufferSource.BufferSource bufferSource;
    private int mColorTL = -1;
    private int mColorTR = -1;
    private int mColorBR = -1;
    private int mColorBL = -1;
    private float mDepth = 0.0f;
    private float mWidth = 1.0f;

    public ExtendedGuiGraphics(@Nonnull GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.bufferSource = guiGraphics.bufferSource();
    }

    public PoseStack pose() {
        return this.guiGraphics.pose();
    }

    public void setColor(int color) {
        this.mColorTL = color;
        this.mColorTR = color;
        this.mColorBR = color;
        this.mColorBL = color;
    }

    public void setGradient(@Nonnull Orientation orientation, int startColor, int endColor) {
        int midColor = TooltipRenderer.lerpInLinearSpace(0.5f, startColor, endColor);
        switch (orientation.ordinal()) {
            case 0: {
                this.mColorTL = startColor;
                this.mColorTR = startColor;
                this.mColorBR = endColor;
                this.mColorBL = endColor;
                break;
            }
            case 1: {
                this.mColorTL = midColor;
                this.mColorTR = startColor;
                this.mColorBR = midColor;
                this.mColorBL = endColor;
                break;
            }
            case 2: {
                this.mColorTL = endColor;
                this.mColorTR = startColor;
                this.mColorBR = startColor;
                this.mColorBL = endColor;
                break;
            }
            case 3: {
                this.mColorTL = endColor;
                this.mColorTR = midColor;
                this.mColorBR = startColor;
                this.mColorBL = midColor;
                break;
            }
            case 4: {
                this.mColorTL = endColor;
                this.mColorTR = endColor;
                this.mColorBR = startColor;
                this.mColorBL = startColor;
                break;
            }
            case 5: {
                this.mColorTL = midColor;
                this.mColorTR = endColor;
                this.mColorBR = midColor;
                this.mColorBL = startColor;
                break;
            }
            case 6: {
                this.mColorTL = startColor;
                this.mColorTR = endColor;
                this.mColorBR = endColor;
                this.mColorBL = startColor;
                break;
            }
            case 7: {
                this.mColorTL = startColor;
                this.mColorTR = midColor;
                this.mColorBR = endColor;
                this.mColorBL = midColor;
            }
        }
    }

    public float getDepth() {
        return this.mDepth;
    }

    public void setDepth(float depth) {
        this.mDepth = depth;
    }

    public float getStrokeWidth() {
        return this.mWidth;
    }

    public void setStrokeWidth(float width) {
        if (width >= 0.0f) {
            this.mWidth = width;
        }
    }

    public void fillCircle(float centerX, float centerY, float radius) {
        this.drawRoundRect(centerX - radius, centerY - radius, centerX + radius, centerY + radius, this.mDepth, radius, -1.0f);
    }

    public void strokeCircle(float centerX, float centerY, float radius) {
        this.drawRoundRect(centerX - radius, centerY - radius, centerX + radius, centerY + radius, this.mDepth, radius, this.mWidth * 0.5f);
    }

    public void fillRoundRect(float left, float top, float right, float bottom, float radius) {
        this.drawRoundRect(left, top, right, bottom, this.mDepth, radius, -1.0f);
    }

    public void strokeRoundRect(float left, float top, float right, float bottom, float radius) {
        this.drawRoundRect(left, top, right, bottom, this.mDepth, radius, this.mWidth * 0.5f);
    }

    private void drawRoundRect(float left, float top, float right, float bottom, float depth, float radius, float thickness) {
        ShaderInstance shader;
        if (!(left < right) || !(top < bottom)) {
            return;
        }
        if (thickness == 0.0f) {
            return;
        }
        if (!Float.isFinite(radius) || radius < 0.0f) {
            radius = 0.0f;
        }
        if ((shader = GuiRenderType.getShaderRoundRect()) == null) {
            return;
        }
        Matrix4f pose = this.guiGraphics.pose().last().pose();
        float centerX = (left + right) * 0.5f;
        float centerY = (top + bottom) * 0.5f;
        float extentX = (right - left) * 0.5f;
        float extentY = (bottom - top) * 0.5f;
        radius = Math.min(radius, Math.min(extentX, extentY));
        float outset = 1.0f + thickness;
        if ((pose.properties() & 8) != 0) {
            shader.safeGetUniform("u_Rect").set(centerX + pose.m30(), centerY + pose.m31(), extentX, extentY);
            shader.safeGetUniform("u_Radii").set(radius, thickness);
            VertexConsumer buffer = this.bufferSource.getBuffer(GuiRenderType.roundRect());
            buffer.addVertex(pose, left - outset, top - outset, depth).setColor(this.mColorTL);
            buffer.addVertex(pose, left - outset, bottom + outset, depth).setColor(this.mColorBL);
            buffer.addVertex(pose, right + outset, bottom + outset, depth).setColor(this.mColorBR);
            buffer.addVertex(pose, right + outset, top - outset, depth).setColor(this.mColorTR);
            this.guiGraphics.flush();
        } else {
            this.guiGraphics.flush();
            RenderSystem.getModelViewStack().pushMatrix();
            RenderSystem.getModelViewStack().mul((Matrix4fc)pose);
            RenderSystem.applyModelViewMatrix();
            shader.safeGetUniform("u_Rect").set(centerX, centerY, extentX, extentY);
            shader.safeGetUniform("u_Radii").set(radius, thickness);
            VertexConsumer buffer = this.bufferSource.getBuffer(GuiRenderType.roundRect());
            buffer.addVertex(left - outset, top - outset, depth).setColor(this.mColorTL);
            buffer.addVertex(left - outset, bottom + outset, depth).setColor(this.mColorBL);
            buffer.addVertex(right + outset, bottom + outset, depth).setColor(this.mColorBR);
            buffer.addVertex(right + outset, top - outset, depth).setColor(this.mColorTR);
            this.guiGraphics.flush();
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static enum Orientation {
        TOP_BOTTOM,
        TR_BL,
        RIGHT_LEFT,
        BR_TL,
        BOTTOM_TOP,
        BL_TR,
        LEFT_RIGHT,
        TL_BR;

    }
}

