/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.vertex.VertexConsumer;
import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.ColorEvaluator;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.ScreenCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundSource;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public final class BlurHandler
extends Enum<BlurHandler> {
    public static final /* enum */ BlurHandler INSTANCE = new BlurHandler();
    private static final ResourceLocation GAUSSIAN_BLUR;
    public static volatile boolean sBlurEffect;
    public static volatile boolean sOverrideVanillaBlur;
    public static volatile int sBlurRadius;
    public static volatile int sBackgroundDuration;
    public static volatile int[] sBackgroundColor;
    public static volatile int sFramerateInactive;
    public static volatile int sFramerateMinimized;
    public static volatile float sMasterVolumeInactive;
    public static volatile float sMasterVolumeMinimized;
    private final Minecraft minecraft = Minecraft.getInstance();
    private volatile ArrayList<Class<? extends Screen>> mBlacklist = new ArrayList();
    private final int[] mBackgroundColor = new int[4];
    private boolean mFadingIn;
    private boolean mBlurring;
    private float mBlurRadius;
    private boolean mHasScreen;
    @Nullable
    private PostChain mBlurEffect;
    private boolean mBlurEffectLoaded;
    private float mVolumeMultiplier = 1.0f;
    private static final /* synthetic */ BlurHandler[] $VALUES;

    public static BlurHandler[] values() {
        return (BlurHandler[])$VALUES.clone();
    }

    public static BlurHandler valueOf(String name) {
        return Enum.valueOf(BlurHandler.class, name);
    }

    public void blur(@Nullable Screen nextScreen) {
        boolean blocked;
        boolean hasScreen;
        block16: {
            block17: {
                if (this.minecraft.level == null) {
                    return;
                }
                hasScreen = nextScreen != null;
                blocked = false;
                if (!hasScreen || !sBlurEffect) break block16;
                if (!(nextScreen instanceof MuiScreen)) break block17;
                MuiScreen screen = (MuiScreen)nextScreen;
                ScreenCallback callback = screen.getCallback();
                if (callback == null) break block16;
                blocked = !callback.shouldBlurBackground();
                break block16;
            }
            Class<?> t = nextScreen.getClass();
            for (Class<? extends Screen> c : this.mBlacklist) {
                if (!c.isAssignableFrom(t)) continue;
                blocked = true;
                break;
            }
        }
        if (blocked && this.mBlurring) {
            this.mBlurring = false;
        }
        if (hasScreen && !this.mHasScreen) {
            if (!blocked && sBlurEffect && !this.mBlurring && sBlurRadius >= 1) {
                if (!this.mBlurEffectLoaded) {
                    this.loadEffect();
                    assert (this.mBlurEffectLoaded);
                }
                if (this.mBlurEffect != null) {
                    this.mBlurring = true;
                }
                if (this.mBlurring) {
                    if (sBackgroundDuration > 0) {
                        this.updateRadius(1.0f);
                    } else {
                        this.updateRadius(sBlurRadius);
                    }
                }
            }
            if (sBackgroundDuration > 0) {
                this.mFadingIn = true;
                Arrays.fill(this.mBackgroundColor, 0);
            } else {
                this.mFadingIn = false;
                System.arraycopy(sBackgroundColor, 0, this.mBackgroundColor, 0, 4);
            }
        } else if (!hasScreen) {
            if (this.mBlurring) {
                this.mBlurring = false;
            }
            this.mFadingIn = false;
        }
        this.mHasScreen = hasScreen;
    }

    public void closeEffect() {
        if (this.mBlurEffect != null) {
            this.mBlurEffect.close();
        }
        this.mBlurEffect = null;
    }

    public void loadEffect() {
        this.closeEffect();
        if (sBlurEffect || sOverrideVanillaBlur) {
            this.mBlurEffectLoaded = true;
            try {
                this.mBlurEffect = new PostChain(this.minecraft.getTextureManager(), (ResourceProvider)this.minecraft.getResourceManager(), this.minecraft.getMainRenderTarget(), GAUSSIAN_BLUR);
                this.mBlurEffect.resize(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
            }
            catch (Exception e) {
                ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to load blur effect", (Throwable)e);
            }
            if (this.mBlurEffect == null) {
                this.mBlurring = false;
            }
        }
    }

    public void resize(int width, int height) {
        if (this.mBlurEffect != null) {
            this.mBlurEffect.resize(width, height);
        }
    }

    public void loadBlacklist(@Nullable List<? extends String> names) {
        ArrayList blacklist = new ArrayList();
        if (names != null) {
            for (String string : names) {
                if (StringUtils.isEmpty((CharSequence)string)) continue;
                try {
                    Class<?> clazz = Class.forName(string, false, ModernUIMod.class.getClassLoader());
                    blacklist.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to add blur blacklist {}: make sure class name exists", (Object)string, (Object)e);
                }
                catch (ClassCastException e) {
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to add blur blacklist {}: make sure class is a valid subclass of Screen", (Object)string, (Object)e);
                }
            }
            blacklist.trimToSize();
        }
        this.mBlacklist = blacklist;
    }

    public void onRenderTick(long elapsedTimeMillis) {
        if (this.mFadingIn) {
            float p = Math.min((float)elapsedTimeMillis / (float)sBackgroundDuration, 1.0f);
            if (this.mBlurring) {
                this.updateRadius(Math.max(p * (float)sBlurRadius, 1.0f));
            }
            for (int i = 0; i < 4; ++i) {
                this.mBackgroundColor[i] = ColorEvaluator.evaluate(p, 0, sBackgroundColor[i]);
            }
            if (p == 1.0f) {
                this.mFadingIn = false;
            }
        }
    }

    private void updateRadius(float radius) {
        this.mBlurRadius = radius;
    }

    private void updateRadius(@Nonnull PostChain effect, float radius) {
        effect.setUniform("Progress", radius);
    }

    public void onClientTick() {
        float targetVolumeMultiplier = this.minecraft.isWindowActive() ? 1.0f : (sMasterVolumeMinimized < sMasterVolumeInactive && GLFW.glfwGetWindowAttrib((long)this.minecraft.getWindow().getWindow(), (int)131074) != 0 ? sMasterVolumeMinimized : sMasterVolumeInactive);
        if (this.mVolumeMultiplier != targetVolumeMultiplier) {
            this.mVolumeMultiplier = this.mVolumeMultiplier < targetVolumeMultiplier ? Math.min(this.mVolumeMultiplier + 0.5f, targetVolumeMultiplier) : Math.max(this.mVolumeMultiplier - 0.05f, targetVolumeMultiplier);
            float volume = this.minecraft.options.getSoundSourceVolume(SoundSource.MASTER);
            this.minecraft.getSoundManager().updateSourceVolume(SoundSource.MASTER, volume * this.mVolumeMultiplier);
        }
    }

    public void drawScreenBackground(@Nonnull GuiGraphics gr, int x1, int y1, int x2, int y2) {
        VertexConsumer consumer = gr.bufferSource().getBuffer(RenderType.gui());
        Matrix4f pose = gr.pose().last().pose();
        boolean z = false;
        if (this.minecraft.level == null) {
            consumer.addVertex(pose, (float)x2, (float)y1, (float)z).setColor(30, 31, 34, 255);
            consumer.addVertex(pose, (float)x1, (float)y1, (float)z).setColor(30, 31, 34, 255);
            consumer.addVertex(pose, (float)x1, (float)y2, (float)z).setColor(30, 31, 34, 255);
            consumer.addVertex(pose, (float)x2, (float)y2, (float)z).setColor(30, 31, 34, 255);
        } else {
            if (this.mBlurring && this.mBlurEffect != null) {
                this.updateRadius(this.mBlurEffect, this.mBlurRadius);
                this.mBlurEffect.process(0.0f);
                this.minecraft.getMainRenderTarget().bindWrite(false);
            }
            int color = this.mBackgroundColor[1];
            consumer.addVertex(pose, (float)x2, (float)y1, (float)z).setColor(color);
            color = this.mBackgroundColor[0];
            consumer.addVertex(pose, (float)x1, (float)y1, (float)z).setColor(color);
            color = this.mBackgroundColor[3];
            consumer.addVertex(pose, (float)x1, (float)y2, (float)z).setColor(color);
            color = this.mBackgroundColor[2];
            consumer.addVertex(pose, (float)x2, (float)y2, (float)z).setColor(color);
        }
        gr.flush();
    }

    public void processBlurEffect(float partialTick) {
        float radius = (float)this.minecraft.options.getMenuBackgroundBlurriness() * 1.8f;
        if (radius >= 1.0f) {
            if (!this.mBlurEffectLoaded) {
                this.loadEffect();
                assert (this.mBlurEffectLoaded);
            }
            if (this.mBlurEffect != null) {
                this.updateRadius(this.mBlurEffect, radius);
                this.mBlurEffect.process(partialTick);
            }
        }
    }

    private static /* synthetic */ BlurHandler[] $values() {
        return new BlurHandler[]{INSTANCE};
    }

    static {
        $VALUES = BlurHandler.$values();
        GAUSSIAN_BLUR = ResourceLocation.withDefaultNamespace((String)"shaders/post/modern_gaussian_blur.json");
        sBackgroundColor = new int[4];
        sMasterVolumeInactive = 1.0f;
        sMasterVolumeMinimized = 1.0f;
    }
}

