/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.markdown;

import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.markdown.MarkdownConfig;
import icyllis.modernui.markdown.MarkdownTheme;
import icyllis.modernui.markdown.MarkdownVisitor;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.widget.TextView;
import java.util.function.Consumer;

public interface MarkdownPlugin {
    default public void configure(@NonNull Registry registry) {
    }

    default public void configureParser(@NonNull Parser.Builder builder) {
    }

    default public void configureTheme(@NonNull MarkdownTheme.Builder builder) {
    }

    default public void configureConfig(@NonNull MarkdownConfig.Builder builder) {
    }

    @NonNull
    default public String processMarkdown(@NonNull String markdown) {
        return markdown;
    }

    default public void beforeRender(@NonNull Node document) {
    }

    default public void afterRender(@NonNull Node document, @NonNull MarkdownVisitor visitor) {
    }

    default public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
    }

    default public void afterSetText(@NonNull TextView textView) {
    }

    public static interface Registry {
        @NonNull
        public <P extends MarkdownPlugin> P require(@NonNull Class<P> var1);

        public <P extends MarkdownPlugin> void require(@NonNull Class<P> var1, @NonNull Consumer<? super P> var2);
    }
}

