/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.drawable;

import icyllis.modernui.annotation.ColorInt;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.AngularGradient;
import icyllis.modernui.graphics.LinearGradient;
import icyllis.modernui.graphics.Matrix;
import icyllis.modernui.graphics.RadialGradient;
import icyllis.modernui.graphics.RectF;
import icyllis.modernui.graphics.Shader;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.graphics.drawable.ShapeDrawable;
import icyllis.modernui.resources.Resources;
import icyllis.modernui.util.ColorStateList;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class GradientDrawable
extends ShapeDrawable {
    public static final int LINEAR_GRADIENT = 0;
    public static final int RADIAL_GRADIENT = 1;
    public static final int ANGULAR_GRADIENT = 2;
    public static final int RADIUS_TYPE_PIXELS = 0;
    public static final int RADIUS_TYPE_FRACTION = 1;
    public static final int RADIUS_TYPE_FRACTION_PARENT = 2;
    private static final Orientation DEFAULT_ORIENTATION = Orientation.TOP_BOTTOM;
    private GradientState mGradientState;
    private float mGradientRadius;

    public GradientDrawable() {
        this(new GradientState(DEFAULT_ORIENTATION, null), null);
    }

    public GradientDrawable(@NonNull Orientation orientation, @Nullable @ColorInt int[] colors) {
        this(new GradientState(orientation, colors), null);
    }

    @Override
    void updateGradient() {
        GradientState st = this.mGradientState;
        int[] gradientColors = null;
        if (st.mGradientColors != null) {
            gradientColors = new int[st.mGradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                if (st.mGradientColors[i] == null) continue;
                gradientColors[i] = st.mGradientColors[i].getDefaultColor();
            }
        }
        if (gradientColors != null) {
            RectF r = this.mRect;
            if (st.mGradient == 0) {
                float x1;
                float y0;
                float x0;
                float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                this.mFillPaint.setShader(new LinearGradient(x0, y0, x1, switch (st.mOrientation) {
                    case Orientation.TOP_BOTTOM -> {
                        x0 = r.left;
                        y0 = r.top;
                        x1 = x0;
                        yield level * r.bottom;
                    }
                    case Orientation.TR_BL -> {
                        x0 = r.right;
                        y0 = r.top;
                        x1 = level * r.left;
                        yield level * r.bottom;
                    }
                    case Orientation.RIGHT_LEFT -> {
                        x0 = r.right;
                        y0 = r.top;
                        x1 = level * r.left;
                        yield y0;
                    }
                    case Orientation.BR_TL -> {
                        x0 = r.right;
                        y0 = r.bottom;
                        x1 = level * r.left;
                        yield level * r.top;
                    }
                    case Orientation.BOTTOM_TOP -> {
                        x0 = r.left;
                        y0 = r.bottom;
                        x1 = x0;
                        yield level * r.top;
                    }
                    case Orientation.BL_TR -> {
                        x0 = r.left;
                        y0 = r.bottom;
                        x1 = level * r.right;
                        yield level * r.top;
                    }
                    case Orientation.LEFT_RIGHT -> {
                        x0 = r.left;
                        y0 = r.top;
                        x1 = level * r.right;
                        yield y0;
                    }
                    default -> {
                        x0 = r.left;
                        y0 = r.top;
                        x1 = level * r.right;
                        yield level * r.bottom;
                    }
                }, gradientColors, st.mPositions, Shader.TileMode.CLAMP, null));
            } else if (st.mGradient == 1) {
                float x0 = r.left + r.width() * st.mCenterX;
                float y0 = r.top + r.height() * st.mCenterY;
                float radius = st.mGradientRadius;
                if (st.mGradientRadiusType == 1) {
                    float width = st.mWidth >= 0 ? (float)st.mWidth : r.width();
                    float height = st.mHeight >= 0 ? (float)st.mHeight : r.height();
                    radius *= Math.min(width, height);
                } else if (st.mGradientRadiusType == 2) {
                    radius *= Math.min(r.width(), r.height());
                }
                if (st.mUseLevel) {
                    radius *= (float)this.getLevel() / 10000.0f;
                }
                this.mGradientRadius = radius;
                if (!(radius > 0.0f)) {
                    radius = 0.001f;
                }
                this.mFillPaint.setShader(new RadialGradient(x0, y0, radius, gradientColors, st.mPositions, Shader.TileMode.CLAMP, null));
            } else if (st.mGradient == 2) {
                float x0 = r.left + r.width() * st.mCenterX;
                float y0 = r.top + r.height() * st.mCenterY;
                float sweep = st.mUseLevel ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
                Matrix matrix = new Matrix();
                matrix.setRotate(-1.5707964f, x0, y0);
                this.mFillPaint.setShader(new AngularGradient(x0, y0, 0.0f, sweep, gradientColors, st.mPositions, Shader.TileMode.CLAMP, matrix));
            }
            if (st.mSolidColors == null) {
                this.mFillPaint.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.mFillPaint.setShader(null);
        }
    }

    public void setGradientType(int gradient) {
        this.mGradientState.setGradientType(gradient);
        this.mShapeIsDirty = true;
        this.invalidateSelf();
    }

    public int getGradientType() {
        return this.mGradientState.mGradient;
    }

    public void setGradientCenter(float x, float y) {
        this.mGradientState.setGradientCenter(x, y);
        this.mShapeIsDirty = true;
        this.invalidateSelf();
    }

    public float getGradientCenterX() {
        return this.mGradientState.mCenterX;
    }

    public float getGradientCenterY() {
        return this.mGradientState.mCenterY;
    }

    public void setGradientRadius(float gradientRadius, int type) {
        this.mGradientState.setGradientRadius(gradientRadius, type);
        this.mShapeIsDirty = true;
        this.invalidateSelf();
    }

    public float getGradientRadius() {
        if (this.mGradientState.mGradient != 1) {
            return 0.0f;
        }
        if (this.mGradientState.mGradientRadiusType == 0) {
            return this.mGradientState.mGradientRadius;
        }
        this.updateRectIsEmpty();
        return this.mGradientRadius;
    }

    public void setUseLevel(boolean useLevel) {
        this.mGradientState.mUseLevel = useLevel;
        this.mShapeIsDirty = true;
        this.invalidateSelf();
    }

    public boolean getUseLevel() {
        return this.mGradientState.mUseLevel;
    }

    @NonNull
    public Orientation getOrientation() {
        return this.mGradientState.mOrientation;
    }

    public void setOrientation(@NonNull Orientation orientation) {
        this.mGradientState.mOrientation = orientation;
        this.mShapeIsDirty = true;
        this.invalidateSelf();
    }

    public void setColors(@Nullable @ColorInt int[] colors) {
        this.setColors(colors, null);
    }

    public void setColors(@Nullable @ColorInt int[] colors, @Nullable float[] offsets) {
        this.mGradientState.setGradientColors(colors);
        this.mGradientState.mPositions = offsets;
        this.mShapeIsDirty = true;
        this.invalidateSelf();
    }

    @Nullable
    public int[] getColors() {
        if (this.mGradientState.mGradientColors == null) {
            return null;
        }
        int[] colors = new int[this.mGradientState.mGradientColors.length];
        for (int i = 0; i < this.mGradientState.mGradientColors.length; ++i) {
            if (this.mGradientState.mGradientColors[i] == null) continue;
            colors[i] = this.mGradientState.mGradientColors[i].getDefaultColor();
        }
        return colors;
    }

    public void setDither(boolean dither) {
        if (dither != this.mGradientState.mDither) {
            this.mGradientState.mDither = dither;
            this.invalidateSelf();
        }
    }

    public boolean isDither() {
        return this.mGradientState.mDither;
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mGradientState = new GradientState(this.mGradientState, null);
            this.mShapeState = this.mGradientState;
            this.updateLocalState(null);
            this.updateLocalState();
            this.mMutated = true;
        }
        return this;
    }

    private GradientDrawable(@NonNull GradientState state, @Nullable Resources res) {
        super(state, res);
        this.mGradientState = state;
        this.updateLocalState();
    }

    private void updateLocalState() {
        GradientState state = this.mGradientState;
        if (state.mSolidColors == null && state.mGradientColors != null) {
            this.mFillPaint.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    static final class GradientState
    extends ShapeDrawable.ShapeState {
        public int mGradient = 0;
        public int mAngle = 0;
        public Orientation mOrientation;
        public ColorStateList[] mGradientColors;
        public float[] mPositions;
        float mCenterX = 0.5f;
        float mCenterY = 0.5f;
        float mGradientRadius = 0.5f;
        int mGradientRadiusType = 1;
        boolean mUseLevel = false;

        public GradientState(@NonNull Orientation orientation, @Nullable int[] gradientColors) {
            this.mOrientation = orientation;
            this.setGradientColors(gradientColors);
        }

        public GradientState(@NonNull GradientState orig, @Nullable Resources res) {
            super(orig, res);
            this.mGradient = orig.mGradient;
            this.mAngle = orig.mAngle;
            this.mOrientation = orig.mOrientation;
            if (orig.mGradientColors != null) {
                this.mGradientColors = (ColorStateList[])orig.mGradientColors.clone();
            }
            if (orig.mPositions != null) {
                this.mPositions = (float[])orig.mPositions.clone();
            }
            this.mCenterX = orig.mCenterX;
            this.mCenterY = orig.mCenterY;
            this.mGradientRadius = orig.mGradientRadius;
            this.mGradientRadiusType = orig.mGradientRadiusType;
            this.mUseLevel = orig.mUseLevel;
        }

        public void setGradientType(int gradient) {
            this.mGradient = gradient;
        }

        public void setGradientCenter(float x, float y) {
            this.mCenterX = x;
            this.mCenterY = y;
        }

        public void setGradientColors(@Nullable int[] colors) {
            if (colors == null) {
                this.mGradientColors = null;
            } else {
                if (this.mGradientColors == null || this.mGradientColors.length != colors.length) {
                    this.mGradientColors = new ColorStateList[colors.length];
                }
                for (int i = 0; i < colors.length; ++i) {
                    this.mGradientColors[i] = ColorStateList.valueOf(colors[i]);
                }
            }
            this.mSolidColors = null;
        }

        @Override
        public void setSolidColors(@Nullable ColorStateList colors) {
            super.setSolidColors(colors);
            this.mGradientColors = null;
        }

        public void setGradientRadius(float gradientRadius, int type) {
            this.mGradientRadius = gradientRadius;
            this.mGradientRadiusType = type;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new GradientDrawable(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(@Nullable Resources res) {
            return new GradientDrawable(this, res);
        }
    }

    public static enum Orientation {
        TOP_BOTTOM,
        TR_BL,
        RIGHT_LEFT,
        BR_TL,
        BOTTOM_TOP,
        BL_TR,
        LEFT_RIGHT,
        TL_BR;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RadiusType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GradientType {
    }
}

