/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.AnticipateOvershootInterpolator;
import icyllis.modernui.animation.BounceInterpolator;
import icyllis.modernui.animation.ViscousFluidInterpolator;
import icyllis.modernui.annotation.NonNull;

@FunctionalInterface
public interface TimeInterpolator {
    @NonNull
    public static final TimeInterpolator LINEAR = t -> t;
    @NonNull
    public static final TimeInterpolator ACCELERATE = t -> t * t;
    @NonNull
    public static final TimeInterpolator DECELERATE = t -> 1.0f - (1.0f - t) * (1.0f - t);
    @NonNull
    public static final TimeInterpolator DECELERATE_CUBIC = t -> (t -= 1.0f) * t * t + 1.0f;
    @NonNull
    public static final TimeInterpolator DECELERATE_QUINTIC = t -> (t -= 1.0f) * t * t * t * t + 1.0f;
    @NonNull
    public static final TimeInterpolator ACCELERATE_DECELERATE = t -> (float)Math.cos(((double)t + 1.0) * Math.PI) * 0.5f + 0.5f;
    @NonNull
    public static final TimeInterpolator SINE = t -> (float)Math.sin(1.5707963267948966 * (double)t);
    @NonNull
    public static final TimeInterpolator ANTICIPATE = t -> t * t * (3.0f * t - 2.0f);
    @NonNull
    public static final TimeInterpolator OVERSHOOT = t -> (t -= 1.0f) * t * (3.0f * t + 2.0f) + 1.0f;
    @NonNull
    public static final TimeInterpolator ANTICIPATE_OVERSHOOT = new AnticipateOvershootInterpolator();
    @NonNull
    public static final TimeInterpolator BOUNCE = new BounceInterpolator();
    @NonNull
    public static final TimeInterpolator VISCOUS_FLUID = new ViscousFluidInterpolator();

    public float getInterpolation(float var1);

    @NonNull
    public static TimeInterpolator linear() {
        return LINEAR;
    }

    @NonNull
    public static TimeInterpolator accelerate() {
        return ACCELERATE;
    }

    @NonNull
    public static TimeInterpolator accelerate(float factor) {
        if (factor == 1.0f) {
            return ACCELERATE;
        }
        double f = (double)factor * 2.0;
        return t -> (float)Math.pow(t, f);
    }

    @NonNull
    public static TimeInterpolator decelerate() {
        return DECELERATE;
    }

    @NonNull
    public static TimeInterpolator decelerate(float factor) {
        if (factor == 1.0f) {
            return DECELERATE;
        }
        if (factor == 1.5f) {
            return DECELERATE_CUBIC;
        }
        if (factor == 2.5f) {
            return DECELERATE_QUINTIC;
        }
        double f = (double)factor * 2.0;
        return t -> (float)(1.0 - Math.pow(1.0 - (double)t, f));
    }

    @NonNull
    public static TimeInterpolator cycle(float cycle) {
        if (cycle == 0.25f) {
            return SINE;
        }
        double f = Math.PI * 2 * (double)cycle;
        return t -> (float)Math.sin(f * (double)t);
    }

    @NonNull
    public static TimeInterpolator anticipate() {
        return ANTICIPATE;
    }

    @NonNull
    public static TimeInterpolator anticipate(float tension) {
        if (tension == 2.0f) {
            return ANTICIPATE;
        }
        return t -> t * t * ((tension + 1.0f) * t - tension);
    }

    @NonNull
    public static TimeInterpolator overshoot() {
        return OVERSHOOT;
    }

    @NonNull
    public static TimeInterpolator overshoot(float tension) {
        if (tension == 2.0f) {
            return OVERSHOOT;
        }
        return t -> (t -= 1.0f) * t * ((tension + 1.0f) * t + tension) + 1.0f;
    }

    @NonNull
    public static TimeInterpolator bounce() {
        return BOUNCE;
    }
}

