/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.vulkan.VulkanAllocation;
import icyllis.arc3d.vulkan.VulkanDevice;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.vma.Vma;
import org.lwjgl.util.vma.VmaAllocationCreateInfo;
import org.lwjgl.util.vma.VmaAllocationInfo;
import org.lwjgl.util.vma.VmaAllocatorCreateInfo;
import org.lwjgl.util.vma.VmaVulkanFunctions;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class VulkanMemoryAllocator
implements AutoCloseable {
    public static final int kDedicatedAllocation_AllocFlag = 1;
    public static final int kPersistentlyMapped_AllocFlag = 2;
    public static final int kLazyAllocation_AllocFlag = 4;
    protected long mAllocator;

    public VulkanMemoryAllocator(long allocator) {
        this.mAllocator = allocator;
    }

    @Nullable
    public static VulkanMemoryAllocator make(VkInstance instance, VkPhysicalDevice physicalDevice, VkDevice device, int physicalDeviceVersion, @NativeType(value="VkDeviceSize") long largeHeapBlockSize) {
        if (physicalDeviceVersion < VK11.VK_API_VERSION_1_1) {
            return null;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            VmaVulkanFunctions pVulkanFunctions = VmaVulkanFunctions.calloc((MemoryStack)stack).set(instance, device);
            VmaAllocatorCreateInfo pCreateInfo = VmaAllocatorCreateInfo.calloc((MemoryStack)stack).flags(2).physicalDevice(physicalDevice).device(device).preferredLargeHeapBlockSize(largeHeapBlockSize != 0L ? largeHeapBlockSize : 0x4000000L).pVulkanFunctions(pVulkanFunctions).instance(instance).vulkanApiVersion(physicalDeviceVersion);
            PointerBuffer pAllocator = stack.pointers(0L);
            if (Vma.vmaCreateAllocator((VmaAllocatorCreateInfo)pCreateInfo, (PointerBuffer)pAllocator) != 0) {
                VulkanMemoryAllocator vulkanMemoryAllocator = null;
                return vulkanMemoryAllocator;
            }
            VulkanMemoryAllocator vulkanMemoryAllocator = new VulkanMemoryAllocator(pAllocator.get(0));
            return vulkanMemoryAllocator;
        }
    }

    @Override
    public void close() {
        if (this.mAllocator != 0L) {
            Vma.vmaDestroyAllocator((long)this.mAllocator);
        }
        this.mAllocator = 0L;
    }

    public boolean allocateBufferMemory(VulkanDevice device, @NativeType(value="VkBuffer") long buffer, int usageFlags, int allocFlags, VulkanAllocation outAllocInfo) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int preferredFlags;
            int requiredFlags;
            int flags = 0;
            if ((allocFlags & 1) != 0) {
                flags |= 1;
            }
            if ((allocFlags & 2) != 0) {
                assert ((usageFlags & 0x20000) != 0);
                flags |= 4;
            }
            if ((usageFlags & 8) != 0) {
                assert ((usageFlags & 0xFF0000) == 131072);
                requiredFlags = 6;
                preferredFlags = 0;
            } else if ((usageFlags & 0x10) != 0) {
                assert ((usageFlags & 0xFF0000) == 131072);
                requiredFlags = 2;
                preferredFlags = 8;
            } else if ((usageFlags & 0xFF0000) == 65536) {
                requiredFlags = 1;
                preferredFlags = (allocFlags & 4) != 0 ? 16 : 0;
            } else {
                requiredFlags = 6;
                preferredFlags = (usageFlags & 0x10000) != 0 ? 1 : 0;
            }
            VmaAllocationCreateInfo pCreateInfo = VmaAllocationCreateInfo.calloc((MemoryStack)stack).flags(flags).usage(0).requiredFlags(requiredFlags).preferredFlags(preferredFlags).memoryTypeBits(0).pool(0L).pUserData(0L);
            PointerBuffer pAllocation = stack.pointers(0L);
            VmaAllocationInfo pAllocationInfo = VmaAllocationInfo.malloc((MemoryStack)stack);
            int result = Vma.vmaAllocateMemoryForBuffer((long)this.mAllocator, (long)buffer, (VmaAllocationCreateInfo)pCreateInfo, (PointerBuffer)pAllocation, (VmaAllocationInfo)pAllocationInfo);
            if (device.checkResult(result)) {
                if (result == 0) {
                    this.getAllocInfo(stack, pAllocation.get(0), pAllocationInfo, outAllocInfo);
                    boolean bl = true;
                    return bl;
                }
                Vma.vmaFreeMemory((long)this.mAllocator, (long)pAllocation.get(0));
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean allocateImageMemory(VulkanDevice device, @NativeType(value="VkImage") long image, int allocFlags, VulkanAllocation outAllocInfo) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VmaAllocationInfo pAllocationInfo;
            PointerBuffer pAllocation;
            int flags = 0;
            if ((allocFlags & 1) != 0) {
                flags |= 1;
            }
            int requiredFlags = 1;
            int preferredFlags = (allocFlags & 4) != 0 ? 16 : 0;
            VmaAllocationCreateInfo pCreateInfo = VmaAllocationCreateInfo.calloc((MemoryStack)stack).flags(flags).usage(0).requiredFlags(requiredFlags).preferredFlags(preferredFlags).memoryTypeBits(0).pool(0L).pUserData(0L);
            int result = Vma.vmaAllocateMemoryForImage((long)this.mAllocator, (long)image, (VmaAllocationCreateInfo)pCreateInfo, (PointerBuffer)(pAllocation = stack.pointers(0L)), (VmaAllocationInfo)(pAllocationInfo = VmaAllocationInfo.malloc((MemoryStack)stack)));
            if (device.checkResult(result)) {
                if (result == 0) {
                    this.getAllocInfo(stack, pAllocation.get(0), pAllocationInfo, outAllocInfo);
                    boolean bl = true;
                    return bl;
                }
                Vma.vmaFreeMemory((long)this.mAllocator, (long)pAllocation.get(0));
            }
            boolean bl = false;
            return bl;
        }
    }

    public void freeMemory(VulkanAllocation allocInfo) {
        assert (allocInfo.mAllocation != 0L);
        Vma.vmaFreeMemory((long)this.mAllocator, (long)allocInfo.mAllocation);
    }

    private void getAllocInfo(MemoryStack stack, @NativeType(value="VmaAllocation") long allocation, VmaAllocationInfo allocationInfo, VulkanAllocation outAllocInfo) {
        IntBuffer pMemFlags = stack.mallocInt(1);
        Vma.vmaGetMemoryTypeProperties((long)this.mAllocator, (int)allocationInfo.memoryType(), (IntBuffer)pMemFlags);
        int memFlags = pMemFlags.get(0);
        int flags = 0;
        if ((memFlags & 2) != 0) {
            flags |= 1;
        }
        if ((memFlags & 4) != 0) {
            flags |= 2;
        }
        if ((memFlags & 0x10) != 0) {
            flags |= 4;
        }
        outAllocInfo.mMemory = allocationInfo.deviceMemory();
        outAllocInfo.mOffset = allocationInfo.offset();
        outAllocInfo.mSize = allocationInfo.size();
        outAllocInfo.mMappedPointer = allocationInfo.pMappedData();
        outAllocInfo.mMemoryFlags = flags;
        outAllocInfo.mAllocation = allocation;
    }
}

