/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.compiler.GLSLVersion;
import icyllis.arc3d.compiler.SPIRVVersion;
import icyllis.arc3d.compiler.TargetApi;
import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.ContextOptions;
import icyllis.arc3d.engine.DataUtils;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.IResourceKey;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.engine.PipelineKey;
import icyllis.arc3d.engine.RenderPassDesc;
import icyllis.arc3d.engine.ShaderCaps;
import icyllis.arc3d.engine.Swizzle;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.engine.trash.PipelineKey_old;
import icyllis.arc3d.vulkan.VKUtil;
import icyllis.arc3d.vulkan.VulkanImage;
import icyllis.arc3d.vulkan.VulkanImageDesc;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkFormatProperties;
import org.lwjgl.vulkan.VkImageFormatProperties;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures2;
import org.lwjgl.vulkan.VkPhysicalDeviceLimits;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VulkanCaps
extends Caps {
    final FormatInfo[] mFormatTable = new FormatInfo[4];
    private final int[] mColorTypeToBackendFormat = new int[26];

    public VulkanCaps(ContextOptions options, VkPhysicalDevice physDev, int physicalDeviceVersion, VkPhysicalDeviceFeatures2 deviceFeatures2, VKCapabilitiesInstance capabilitiesInstance, VKCapabilitiesDevice capabilitiesDevice) {
        super(options);
        this.mDepthClipNegativeOneToOne = false;
        ShaderCaps shaderCaps = this.mShaderCaps;
        shaderCaps.mTargetApi = TargetApi.VULKAN_1_0;
        shaderCaps.mGLSLVersion = GLSLVersion.GLSL_450;
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkPhysicalDeviceProperties physProps = VkPhysicalDeviceProperties.malloc((MemoryStack)stack);
            VK11.vkGetPhysicalDeviceProperties((VkPhysicalDevice)physDev, (VkPhysicalDeviceProperties)physProps);
            VkPhysicalDeviceLimits limits = physProps.limits();
            shaderCaps.mSPIRVVersion = Integer.compareUnsigned(physicalDeviceVersion, VK11.VK_MAKE_VERSION((int)1, (int)3, (int)0)) >= 0 ? SPIRVVersion.SPIRV_1_6 : (Integer.compareUnsigned(physicalDeviceVersion, VK11.VK_MAKE_VERSION((int)1, (int)2, (int)0)) >= 0 ? SPIRVVersion.SPIRV_1_5 : (Integer.compareUnsigned(physicalDeviceVersion, VK11.VK_MAKE_VERSION((int)1, (int)1, (int)0)) >= 0 ? SPIRVVersion.SPIRV_1_3 : SPIRVVersion.SPIRV_1_0));
            this.mMaxTextureSize = (int)Math.min(Integer.toUnsignedLong(limits.maxImageDimension2D()), Integer.MAX_VALUE);
            this.initFormatTable(options, physDev, physProps, stack);
        }
    }

    void initFormatTable(ContextOptions options, VkPhysicalDevice physDev, VkPhysicalDeviceProperties physProps, MemoryStack stack) {
        for (int i = 1; i < this.mFormatTable.length; ++i) {
            this.mFormatTable[i] = new FormatInfo();
        }
        int format = 37;
        FormatInfo info = this.getFormatInfo(37);
        info.init(options, physDev, physProps, 37, stack);
        if (info.isSampled(0)) {
            info.mColorTypeInfos = new ColorTypeInfo[2];
            ColorTypeInfo ctInfo = info.mColorTypeInfos[0] = new ColorTypeInfo();
            ctInfo.mColorType = 6;
            ctInfo.mTransferColorType = 6;
            ctInfo.mFlags = 3;
            ctInfo = info.mColorTypeInfos[1] = new ColorTypeInfo();
            ctInfo.mColorType = 5;
            ctInfo.mTransferColorType = 5;
            ctInfo.mFlags = 1;
            ctInfo.mReadSwizzle = (short)21008;
        }
        this.mFormatTable[0] = new FormatInfo();
        this.setColorTypeFormat(6, 37);
    }

    FormatInfo getFormatInfo(@NativeType(value="VkFormat") int format) {
        return this.mFormatTable[VKUtil.vkFormatToIndex(format)];
    }

    private void setColorTypeFormat(int colorType, int ... formats) {
        for (int format : formats) {
            assert (VKUtil.vkFormatIsSupported(format));
            FormatInfo info = this.getFormatInfo(format);
            for (ColorTypeInfo ctInfo : info.mColorTypeInfos) {
                if (ctInfo.mColorType != colorType) continue;
                this.mColorTypeToBackendFormat[colorType] = format;
                return;
            }
        }
    }

    public boolean hasUnifiedMemory() {
        return false;
    }

    @Override
    public boolean isFormatTexturable(BackendFormat format) {
        return false;
    }

    @Override
    public int getMaxRenderTargetSampleCount(BackendFormat format) {
        return 0;
    }

    @Override
    public boolean isFormatRenderable(int colorType, BackendFormat format, int sampleCount) {
        return false;
    }

    @Override
    public boolean isFormatRenderable(BackendFormat format, int sampleCount) {
        return false;
    }

    @Override
    public int getRenderTargetSampleCount(int sampleCount, BackendFormat format) {
        return 0;
    }

    @Override
    public long getSupportedWriteColorType(int dstColorType, ImageDesc dstDesc, int srcColorType) {
        return 0L;
    }

    @Override
    protected long onSupportedReadColorType(int srcColorType, BackendFormat srcFormat, int dstColorType) {
        return 0L;
    }

    @Override
    protected boolean onFormatCompatible(int colorType, BackendFormat format) {
        return false;
    }

    @Override
    @Nullable
    public ImageDesc getDefaultColorImageDesc(int imageType, int colorType, int width, int height, int depthOrArraySize, int mipLevelCount, int sampleCount, int imageFlags) {
        int arraySize;
        int depth;
        if (width < 1 || height < 1 || depthOrArraySize < 1 || mipLevelCount < 0 || sampleCount < 0) {
            return null;
        }
        sampleCount = Math.max(1, sampleCount);
        int format = this.mColorTypeToBackendFormat[colorType];
        FormatInfo formatInfo = this.getFormatInfo(format);
        if ((imageFlags & 8) != 0 && !formatInfo.isSampled(0)) {
            return null;
        }
        if ((imageFlags & 0x10) != 0 && !formatInfo.isStorage(0)) {
            return null;
        }
        if ((imageFlags & 0x20) != 0 && !formatInfo.isRenderable(0, sampleCount)) {
            return null;
        }
        switch (imageType) {
            case 5: {
                depth = depthOrArraySize;
                arraySize = 1;
                break;
            }
            case 2: 
            case 4: {
                depth = 1;
                arraySize = depthOrArraySize;
                break;
            }
            default: {
                arraySize = 1;
                depth = 1;
            }
        }
        if (width > this.mMaxTextureSize || height > this.mMaxTextureSize) {
            return null;
        }
        int maxMipLevels = DataUtils.computeMipLevelCount(width, height, depth);
        mipLevelCount = mipLevelCount == 0 ? ((imageFlags & 4) != 0 ? maxMipLevels : 1) : Math.min(mipLevelCount, maxMipLevels);
        if (sampleCount > 1 && mipLevelCount > 1) {
            return null;
        }
        int usage = 3;
        if ((imageFlags & 8) != 0) {
            usage |= 4;
        }
        if ((imageFlags & 0x10) != 0) {
            usage |= 8;
        }
        if ((imageFlags & 0x20) != 0) {
            usage |= 0x90;
            if ((imageFlags & 0x40) != 0) {
                usage |= 0x40;
            }
        }
        return new VulkanImageDesc(0, 1, format, 0, usage, 0, imageType, width, height, depth, arraySize, mipLevelCount, sampleCount, imageFlags);
    }

    @Override
    @Nullable
    protected BackendFormat onGetDefaultBackendFormat(int colorType) {
        return null;
    }

    @Override
    @Nullable
    public BackendFormat getCompressedBackendFormat(int compressionType) {
        return null;
    }

    @Override
    @Nonnull
    public PipelineKey_old makeDesc(PipelineKey_old desc, GpuRenderTarget renderTarget, GraphicsPipelineDesc_Old graphicsPipelineDesc) {
        return null;
    }

    @Override
    @Nonnull
    public PipelineKey makeGraphicsPipelineKey(PipelineKey old, PipelineDesc pipelineDesc, RenderPassDesc renderPassDesc) {
        return null;
    }

    @Override
    protected short onGetReadSwizzle(ImageDesc desc, int colorType) {
        return 0;
    }

    @Override
    public short getWriteSwizzle(ImageDesc desc, int colorType) {
        return 0;
    }

    @Override
    public IResourceKey computeImageKey(ImageDesc desc, IResourceKey recycle) {
        if (desc instanceof VulkanImageDesc) {
            VulkanImageDesc vulkanDesc = (VulkanImageDesc)desc;
            return new VulkanImage.ResourceKey(vulkanDesc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int[] initSampleCounts(ContextOptions options, VkPhysicalDevice physDev, VkPhysicalDeviceProperties physProps, int format, int usage, MemoryStack stack) {
        stack.push();
        try {
            VkImageFormatProperties props = VkImageFormatProperties.malloc((MemoryStack)stack);
            int result = VK11.vkGetPhysicalDeviceImageFormatProperties((VkPhysicalDevice)physDev, (int)format, (int)1, (int)0, (int)usage, (int)0, (VkImageFormatProperties)props);
            if (result != 0) {
                options.mLogger.warn("Failed to vkGetPhysicalDeviceImageFormatProperties: {}", (Object)VKUtil.getResultMessage(result));
                int[] nArray = IntArrays.EMPTY_ARRAY;
                return nArray;
            }
            IntArrayList sampleCounts = new IntArrayList(5);
            int flags = props.sampleCounts();
            if ((flags & 1) != 0) {
                sampleCounts.add(1);
            }
            if ((flags & 2) != 0) {
                sampleCounts.add(2);
            }
            if ((flags & 4) != 0) {
                sampleCounts.add(4);
            }
            if ((flags & 8) != 0) {
                sampleCounts.add(8);
            }
            if ((flags & 0x10) != 0) {
                sampleCounts.add(16);
            }
            int[] nArray = sampleCounts.toIntArray();
            return nArray;
        }
        finally {
            stack.pop();
        }
    }

    static class FormatInfo {
        int mOptimalTilingFeatures = 0;
        int mLinearTilingFeatures = 0;
        int[] mColorSampleCounts = IntArrays.EMPTY_ARRAY;
        ColorTypeInfo[] mColorTypeInfos = new ColorTypeInfo[0];

        FormatInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init(ContextOptions options, VkPhysicalDevice physDev, VkPhysicalDeviceProperties physProps, int format, MemoryStack stack) {
            stack.push();
            try {
                VkFormatProperties props = VkFormatProperties.calloc((MemoryStack)stack);
                VK11.vkGetPhysicalDeviceFormatProperties((VkPhysicalDevice)physDev, (int)format, (VkFormatProperties)props);
                this.mOptimalTilingFeatures = props.optimalTilingFeatures();
                this.mLinearTilingFeatures = props.linearTilingFeatures();
                if ((this.mOptimalTilingFeatures & 0x100) != 0) {
                    int usage = 151;
                    this.mColorSampleCounts = VulkanCaps.initSampleCounts(options, physDev, physProps, format, usage, stack);
                }
            }
            finally {
                stack.pop();
            }
        }

        boolean isSampled(int imageTiling) {
            return switch (imageTiling) {
                case 0 -> {
                    if ((this.mOptimalTilingFeatures & 1) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if ((this.mLinearTilingFeatures & 1) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        boolean isStorage(int imageTiling) {
            return switch (imageTiling) {
                case 0 -> {
                    if ((this.mOptimalTilingFeatures & 2) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if ((this.mLinearTilingFeatures & 2) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        boolean isFilterable(int imageTiling) {
            return switch (imageTiling) {
                case 0 -> {
                    if ((this.mOptimalTilingFeatures & 0x1000) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if ((this.mLinearTilingFeatures & 0x1000) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        boolean isRenderable(int imageTiling, int sampleCount) {
            if (imageTiling == 0) {
                if (this.mColorSampleCounts.length == 0) {
                    return false;
                }
                return sampleCount <= this.mColorSampleCounts[this.mColorSampleCounts.length - 1];
            }
            return false;
        }

        boolean isTransferSrc(int imageTiling) {
            return switch (imageTiling) {
                case 0 -> {
                    if ((this.mOptimalTilingFeatures & 0x4000) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if ((this.mLinearTilingFeatures & 0x4000) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        boolean isTransferDst(int imageTiling) {
            return switch (imageTiling) {
                case 0 -> {
                    if ((this.mOptimalTilingFeatures & 0x8000) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if ((this.mLinearTilingFeatures & 0x8000) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public String toString() {
            return "FormatInfo{optimalTilingFeatures=0x" + Integer.toHexString(this.mOptimalTilingFeatures) + ", linearTilingFeatures=0x" + Integer.toHexString(this.mLinearTilingFeatures) + ", colorSampleCounts=" + Arrays.toString(this.mColorSampleCounts) + ", colorTypeInfos=" + Arrays.toString(this.mColorTypeInfos) + "}";
        }
    }

    static class ColorTypeInfo {
        int mColorType = 0;
        int mTransferColorType = 0;
        static final int kUploadData_Flag = 1;
        static final int kRenderable_Flag = 2;
        int mFlags = 0;
        short mReadSwizzle = (short)12816;
        short mWriteSwizzle = (short)12816;

        ColorTypeInfo() {
        }

        public String toString() {
            return "ColorTypeInfo{colorType=" + ColorInfo.colorTypeToString(this.mColorType) + ", transferColorType=" + ColorInfo.colorTypeToString(this.mTransferColorType) + ", flags=0x" + Integer.toHexString(this.mFlags) + ", readSwizzle=" + Swizzle.toString(this.mReadSwizzle) + ", writeSwizzle=" + Swizzle.toString(this.mWriteSwizzle) + "}";
        }
    }
}

