/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine.trash.ops;

import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.ImageProxyView;
import icyllis.arc3d.engine.MeshDrawTarget;
import icyllis.arc3d.engine.OpFlushState;
import icyllis.arc3d.engine.OpsRenderPass;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.engine.trash.ops.MeshDrawOp;
import icyllis.arc3d.engine.trash.ops.Op;
import icyllis.arc3d.granite.geom.SDFRectGeoProc;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.lwjgl.system.MemoryUtil;

@Deprecated
public class RectOp
extends MeshDrawOp {
    private Buffer mVertexBuffer;
    private int mBaseVertex;
    private Buffer mInstanceBuffer;
    private int mBaseInstance;
    private final int mColor;
    private final Rect2f mLocalRect;
    private final float mStrokeRadius;
    private final float mStrokePos;
    private final Matrix mViewMatrix;
    private final int mGPFlags;
    private int mNumInstances = 1;

    public RectOp(int argb, Rect2f localRect, float strokeRadius, float strokePos, Matrixc viewMatrix, boolean stroke, boolean aa) {
        this.mColor = argb;
        this.mLocalRect = localRect;
        this.mStrokeRadius = strokeRadius;
        this.mStrokePos = strokePos;
        this.mViewMatrix = !viewMatrix.isIdentity() ? new Matrix(viewMatrix) : null;
        int gpFlags = 0;
        if (aa) {
            gpFlags |= 1;
        }
        if (stroke) {
            gpFlags |= 2;
        }
        if (this.mViewMatrix != null) {
            gpFlags |= 4;
        }
        this.mGPFlags = gpFlags;
        if (this.mViewMatrix != null) {
            this.mViewMatrix.mapRect((Rect2fc)localRect, this);
        } else {
            this.set(localRect);
        }
        this.setBoundsFlags(aa, false);
    }

    @Override
    protected boolean onMayChain(@Nonnull Op __) {
        RectOp op = (RectOp)__;
        if (op.mGPFlags == this.mGPFlags) {
            ++this.mNumInstances;
            return true;
        }
        return false;
    }

    @Override
    public void onExecute(OpFlushState state, Rect2f chainBounds) {
        OpsRenderPass opsRenderPass = state.getOpsRenderPass();
        opsRenderPass.bindPipeline(this.getPipelineInfo(), this.getPipelineState(), chainBounds);
        opsRenderPass.bindTextures(null);
        opsRenderPass.bindBuffers(null, 0, this.mVertexBuffer, 0, this.mInstanceBuffer, 0);
        opsRenderPass.drawInstanced(this.getInstanceCount(), this.mBaseInstance, this.getVertexCount(), this.mBaseVertex);
    }

    @Override
    @Nonnull
    protected GraphicsPipelineDesc_Old onCreatePipelineInfo(ImageProxyView writeView, int pipelineFlags) {
        return new GraphicsPipelineDesc_Old(writeView, new SDFRectGeoProc(this.mGPFlags), null, null, null, null, pipelineFlags);
    }

    @Override
    public int getVertexCount() {
        return 4;
    }

    @Override
    public int getInstanceCount() {
        return this.mNumInstances;
    }

    @Override
    public void setVertexBuffer(@SharedPtr Buffer buffer, int baseVertex, int actualVertexCount) {
        assert (this.mVertexBuffer == null);
        this.mVertexBuffer = buffer;
        this.mBaseVertex = baseVertex;
    }

    @Override
    public void setInstanceBuffer(@SharedPtr Buffer buffer, int baseInstance, int actualInstanceCount) {
        assert (this.mInstanceBuffer == null);
        this.mInstanceBuffer = buffer;
        this.mBaseInstance = baseInstance;
    }

    @Override
    protected void onPrepareDraws(MeshDrawTarget target) {
        ByteBuffer vertexData = target.makeVertexWriter(this);
        if (vertexData == null) {
            return;
        }
        vertexData.putFloat(-1.0f).putFloat(1.0f);
        vertexData.putFloat(1.0f).putFloat(1.0f);
        vertexData.putFloat(-1.0f).putFloat(-1.0f);
        vertexData.putFloat(1.0f).putFloat(-1.0f);
        ByteBuffer instanceData = target.makeInstanceWriter(this);
        if (instanceData == null) {
            return;
        }
        for (Op it = this; it != null; it = it.nextInChain()) {
            RectOp op = it;
            int color = op.mColor;
            instanceData.put((byte)(color >> 16));
            instanceData.put((byte)(color >> 8));
            instanceData.put((byte)color);
            instanceData.put((byte)(color >> 24));
            instanceData.putFloat(op.mLocalRect.width() / 2.0f);
            instanceData.putFloat(op.mLocalRect.centerX());
            instanceData.putFloat(op.mLocalRect.height() / 2.0f);
            instanceData.putFloat(op.mLocalRect.centerY());
            if ((op.mGPFlags & 2) != 0) {
                instanceData.putFloat(op.mStrokeRadius).putFloat(op.mStrokePos);
            }
            if ((op.mGPFlags & 4) == 0) continue;
            op.mViewMatrix.store(MemoryUtil.memAddress((ByteBuffer)instanceData));
            instanceData.position(instanceData.position() + 36);
        }
    }
}

