/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine.task;

import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.task.Task;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class TaskList
implements Consumer<Task>,
AutoCloseable {
    private final ObjectArrayList<@SharedPtr Task> mTasks = new ObjectArrayList();

    public void appendTask(@SharedPtr Task task) {
        this.mTasks.add((Object)task);
    }

    public void prependTask(@SharedPtr Task task) {
        this.mTasks.add(0, (Object)task);
    }

    @Override
    public void accept(@SharedPtr Task task) {
        this.mTasks.add((Object)task);
    }

    public void appendTasks(@Nonnull TaskList tasks) {
        assert (tasks != this);
        this.mTasks.addAll(tasks.mTasks);
        tasks.mTasks.clear();
    }

    public void appendTasks(@Nonnull List<@SharedPtr ? extends Task> tasks) {
        this.mTasks.addAll(tasks);
        tasks.clear();
    }

    public int size() {
        return this.mTasks.size();
    }

    public boolean isEmpty() {
        return this.mTasks.isEmpty();
    }

    public void clear() {
        for (Task task : this.mTasks) {
            if (task == null) continue;
            task.unref();
        }
        this.mTasks.clear();
    }

    public int prepare(RecordingContext context) {
        int discardCount = 0;
        ObjectListIterator it = this.mTasks.listIterator();
        while (it.hasNext()) {
            Task task = (Task)it.next();
            if (task == null) {
                ++discardCount;
                continue;
            }
            int result = task.prepare(context);
            if (result == 1) {
                return 1;
            }
            if (result != 2) continue;
            task.unref();
            it.set(null);
            ++discardCount;
        }
        return discardCount == this.mTasks.size() ? 2 : 0;
    }

    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        int discardCount = 0;
        ObjectListIterator it = this.mTasks.listIterator();
        while (it.hasNext()) {
            Task task = (Task)it.next();
            if (task == null) {
                ++discardCount;
                continue;
            }
            int result = task.execute(context, commandBuffer);
            if (result == 1) {
                return 1;
            }
            if (result != 2) continue;
            task.unref();
            it.set(null);
            ++discardCount;
        }
        return discardCount == this.mTasks.size() ? 2 : 0;
    }

    @Override
    public void close() {
        this.clear();
    }
}

