/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.SLDataType;
import icyllis.arc3d.engine.Engine;
import icyllis.arc3d.engine.KeyBuilder;
import icyllis.arc3d.engine.ShaderVar;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VertexInputLayout {
    public static final int INPUT_RATE_VERTEX = 0;
    public static final int INPUT_RATE_INSTANCE = 1;
    private final AttributeSet[] mAttributeSets;
    private final int[] mMasks;

    public VertexInputLayout(AttributeSet ... attributeSets) {
        this(attributeSets, (int[])null);
    }

    public VertexInputLayout(@Nonnull AttributeSet[] attributeSets, @Nullable int[] masks) {
        assert (attributeSets.length > 0 && attributeSets.length <= 32);
        assert (masks == null || attributeSets.length == masks.length);
        this.mAttributeSets = attributeSets;
        if (masks != null) {
            for (int i = 0; i < masks.length; ++i) {
                if (masks[i] == 0) continue;
                int n = i;
                masks[n] = masks[n] | attributeSets[i].mAllMask;
            }
        }
        this.mMasks = masks;
    }

    public int getBindingCount() {
        return this.mAttributeSets.length;
    }

    public int getAttributeCount(int binding) {
        if (this.mMasks != null) {
            return Integer.bitCount(this.mMasks[binding]);
        }
        AttributeSet attributes = this.mAttributeSets[binding];
        return attributes != null ? attributes.mAttributes.length : 0;
    }

    public int getLocationCount(int binding) {
        AttributeSet attributes = this.mAttributeSets[binding];
        if (this.mMasks != null) {
            int mask = this.mMasks[binding];
            return mask != 0 ? attributes.numLocations(mask) : 0;
        }
        return attributes != null ? attributes.numLocations(attributes.mAllMask) : 0;
    }

    public int getStride(int binding) {
        AttributeSet attributes = this.mAttributeSets[binding];
        if (this.mMasks != null) {
            int mask = this.mMasks[binding];
            return mask != 0 ? attributes.stride(mask) : 0;
        }
        return attributes != null ? attributes.stride(attributes.mAllMask) : 0;
    }

    public int getInputRate(int binding) {
        AttributeSet attributes = this.mAttributeSets[binding];
        return attributes != null ? attributes.mInputRate : 0;
    }

    @Nonnull
    public Iterator<Attribute> getAttributes(int binding) {
        AttributeSet attributes = this.mAttributeSets[binding];
        if (this.mMasks != null) {
            AttributeSet.Iter iter;
            int mask = this.mMasks[binding];
            if (mask != 0) {
                AttributeSet attributeSet = attributes;
                Objects.requireNonNull(attributeSet);
                iter = attributeSet.new AttributeSet.Iter(mask);
            } else {
                iter = Collections.emptyIterator();
            }
            return iter;
        }
        return attributes != null ? attributes.iterator() : Collections.emptyIterator();
    }

    @Immutable
    public static class AttributeSet
    implements Iterable<Attribute> {
        private final Attribute[] mAttributes;
        private final int mStride;
        private final int mInputRate;
        final int mAllMask;

        private AttributeSet(@Nonnull Attribute[] attributes, int stride, int inputRate) {
            int offset = 0;
            for (Attribute attr2 : attributes) {
                if (attr2.offset() == 1) continue;
                if (attr2.offset() < offset) {
                    throw new IllegalArgumentException();
                }
                offset = attr2.offset();
                assert (Attribute.alignOffset(offset) == offset);
            }
            this.mAttributes = attributes;
            this.mStride = stride;
            this.mInputRate = inputRate;
            this.mAllMask = -1 >>> 32 - this.mAttributes.length;
        }

        @Nonnull
        public static AttributeSet makeImplicit(int inputRate, Attribute ... attrs) {
            if (attrs.length == 0 || attrs.length > 32) {
                throw new IllegalArgumentException();
            }
            return new AttributeSet(attrs, 1, inputRate);
        }

        @Nonnull
        public static AttributeSet makeExplicit(int stride, int inputRate, Attribute ... attrs) {
            if (attrs.length == 0 || attrs.length > 32) {
                throw new IllegalArgumentException();
            }
            if (stride <= 0 || stride > 32768) {
                throw new IllegalArgumentException();
            }
            if (Attribute.alignOffset(stride) != stride) {
                throw new IllegalArgumentException();
            }
            return new AttributeSet(attrs, stride, inputRate);
        }

        final int stride(int mask) {
            if (this.mStride != 1) {
                return this.mStride;
            }
            int rawCount = this.mAttributes.length;
            int stride = 0;
            int i = 0;
            int bit = 1;
            while (i < rawCount) {
                Attribute attr2 = this.mAttributes[i];
                if ((mask & bit) != 0) {
                    if (attr2.offset() != 1) {
                        stride = attr2.offset();
                    }
                    stride += Attribute.alignOffset(attr2.stride());
                }
                ++i;
                bit <<= 1;
            }
            return stride;
        }

        final int numLocations(int mask) {
            int rawCount = this.mAttributes.length;
            int locations = 0;
            int i = 0;
            int bit = 1;
            while (i < rawCount) {
                Attribute attr2 = this.mAttributes[i];
                if ((mask & bit) != 0) {
                    locations += attr2.locations();
                }
                ++i;
                bit <<= 1;
            }
            return locations;
        }

        final void appendToKey(@Nonnull KeyBuilder b, int mask) {
            int stride;
            int rawCount = this.mAttributes.length;
            b.addBits(6, rawCount, "attribute count");
            int offset = 0;
            int i = 0;
            int bit = 1;
            while (i < rawCount) {
                Attribute attr2 = this.mAttributes[i];
                if ((mask & bit) != 0) {
                    b.addBits(8, attr2.srcType() & 0xFF, "attrType");
                    b.addBits(8, attr2.dstType() & 0xFF, "attrGpuType");
                    if (attr2.offset() != 1) {
                        offset = attr2.offset();
                    }
                    assert (offset >= 0 && offset < 32768);
                    b.addBits(16, offset, "attrOffset");
                    offset += Attribute.alignOffset(attr2.stride());
                } else {
                    b.addBits(8, 255, "attrType");
                    b.addBits(8, 255, "attrGpuType");
                    b.addBits(16, 65535, "attrOffset");
                }
                ++i;
                bit <<= 1;
            }
            if (this.mStride == 1) {
                stride = offset;
            } else {
                stride = this.mStride;
                if (stride < offset) {
                    throw new IllegalStateException();
                }
            }
            assert (stride > 0 && stride <= 32768);
            assert (Attribute.alignOffset(stride) == stride);
            b.addBits(16, stride, "stride");
        }

        @Override
        @Nonnull
        public Iterator<Attribute> iterator() {
            return new Iter(this.mAllMask);
        }

        class Iter
        implements Iterator<Attribute> {
            private final int mMask;
            private int mIndex;
            private int mOffset;

            Iter(int mask) {
                this.mMask = mask;
            }

            @Override
            public boolean hasNext() {
                this.forward();
                return this.mIndex < AttributeSet.this.mAttributes.length;
            }

            @Override
            @Nonnull
            public Attribute next() {
                this.forward();
                try {
                    Attribute ret;
                    Attribute curr = AttributeSet.this.mAttributes[this.mIndex++];
                    if (curr.offset() == 1) {
                        ret = new Attribute(curr.name(), curr.srcType(), curr.dstType(), this.mOffset);
                    } else {
                        ret = curr;
                        this.mOffset = curr.offset();
                    }
                    this.mOffset += Attribute.alignOffset(curr.stride());
                    return ret;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException(e);
                }
            }

            private void forward() {
                while (this.mIndex < AttributeSet.this.mAttributes.length && (this.mMask & 1 << this.mIndex) == 0) {
                    ++this.mIndex;
                }
            }
        }
    }

    @Immutable
    public static class Attribute {
        static final int IMPLICIT_OFFSET = 1;
        public static final int OFFSET_ALIGNMENT = 4;
        private final String mName;
        private final byte mSrcType;
        private final byte mDstType;
        private final short mOffset;

        public static int alignOffset(int offset) {
            return MathUtil.align4(offset);
        }

        public Attribute(@Nonnull String name, byte srcType, byte dstType) {
            if (name.isEmpty() || name.startsWith("_")) {
                throw new IllegalArgumentException();
            }
            if (srcType < 0 || srcType > 25) {
                throw new IllegalArgumentException();
            }
            if (SLDataType.locations(dstType) <= 0) {
                throw new IllegalArgumentException();
            }
            this.mName = name;
            this.mSrcType = srcType;
            this.mDstType = dstType;
            this.mOffset = 1;
        }

        public Attribute(@Nonnull String name, byte srcType, byte dstType, int offset) {
            if (name.isEmpty() || name.startsWith("_")) {
                throw new IllegalArgumentException();
            }
            if (srcType < 0 || srcType > 25) {
                throw new IllegalArgumentException();
            }
            if (SLDataType.locations(dstType) <= 0) {
                throw new IllegalArgumentException();
            }
            if (offset < 0 || offset >= 32768 || Attribute.alignOffset(offset) != offset) {
                throw new IllegalArgumentException();
            }
            this.mName = name;
            this.mSrcType = srcType;
            this.mDstType = dstType;
            this.mOffset = (short)offset;
        }

        public final String name() {
            return this.mName;
        }

        public final byte srcType() {
            return this.mSrcType;
        }

        public final byte dstType() {
            return this.mDstType;
        }

        public final int offset() {
            assert (this.mOffset >= 0);
            return this.mOffset;
        }

        public final int size() {
            return Engine.VertexAttribType.size(this.mSrcType);
        }

        public final int locations() {
            return SLDataType.locations(this.mDstType);
        }

        public final int stride() {
            int size = this.size();
            int count = this.locations();
            assert (size > 0 && count > 0);
            return size * count;
        }

        @Nonnull
        public final ShaderVar asShaderVar() {
            return new ShaderVar(this.mName, this.mDstType, 2);
        }
    }
}

