/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.OpFlushState;
import icyllis.arc3d.engine.RenderTargetProxy;
import icyllis.arc3d.engine.RenderTask;
import icyllis.arc3d.engine.RenderTaskManager;
import icyllis.arc3d.engine.SurfaceProxy;
import java.util.ArrayList;
import java.util.List;

public final class TextureResolveTask
extends RenderTask {
    private final List<Resolve> mResolves = new ArrayList<Resolve>(4);

    public TextureResolveTask(RenderTaskManager taskManager) {
        super(taskManager);
    }

    public void addResolveTarget(@SharedPtr SurfaceProxy proxy, int resolveFlags) {
        Rect2ic msaaRect;
        assert (this.mTaskManager.getLastRenderTask(proxy) == null || this.mTaskManager.getLastRenderTask(proxy).isClosed());
        assert (resolveFlags != 0);
        if ((resolveFlags & 1) != 0) {
            RenderTargetProxy renderTargetProxy = proxy.asRenderTargetProxy();
            assert (renderTargetProxy != null);
            assert (renderTargetProxy.needsResolve());
            msaaRect = renderTargetProxy.getResolveRect();
            renderTargetProxy.setResolveRect(0, 0, 0, 0);
        } else {
            msaaRect = Rect2i.empty();
        }
        if ((resolveFlags & 2) != 0) {
            ImageViewProxy imageViewProxy = proxy.asImageProxy();
            assert (imageViewProxy != null);
        }
        this.mResolves.add(new Resolve(resolveFlags, msaaRect.left(), msaaRect.top(), msaaRect.right(), msaaRect.bottom()));
        this.addTarget(proxy);
    }

    @Override
    public boolean execute(OpFlushState flushState) {
        return false;
    }

    private record Resolve(int flags, int msaaLeft, int msaaTop, int msaaRight, int msaaBottom) {
    }
}

