/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class PriorityQueue<E>
extends AbstractQueue<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    protected transient E[] mHeap;
    protected int mSize;
    protected Comparator<? super E> mComparator;
    protected Access<? super E> mAccess;

    public PriorityQueue() {
        this(11, null, null);
    }

    public PriorityQueue(int priority) {
        this(priority, null, null);
    }

    public PriorityQueue(Access<? super E> access) {
        this(11, null, access);
    }

    public PriorityQueue(int capacity, Access<? super E> access) {
        this(capacity, null, access);
    }

    public PriorityQueue(Comparator<? super E> comparator, Access<? super E> access) {
        this(11, comparator, access);
    }

    public PriorityQueue(int capacity, Comparator<? super E> comparator, Access<? super E> access) {
        this.mHeap = new Object[Math.max(1, capacity)];
        this.mComparator = comparator;
        this.mAccess = access;
    }

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + Math.max(minCapacity - oldCapacity, (oldCapacity = this.mHeap.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        this.mHeap = Arrays.copyOf(this.mHeap, newCapacity);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        int i = this.mSize;
        if (i >= this.mHeap.length) {
            this.grow(i + 1);
        }
        this.siftUp(i, Objects.requireNonNull(e));
        this.mSize = i + 1;
        return true;
    }

    @Override
    public E peek() {
        return this.mHeap[0];
    }

    private int indexOf(Object o) {
        if (o != null) {
            if (this.mAccess != null) {
                return this.mAccess.getIndex(o);
            }
            E[] es = this.mHeap;
            int n = this.mSize;
            for (int i = 0; i < n; ++i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.mHeap, this.mSize);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.mSize;
        if (a.length < size) {
            return Arrays.copyOf(this.mHeap, size, a.getClass());
        }
        System.arraycopy(this.mHeap, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        E[] es = this.mHeap;
        if (this.mAccess != null) {
            int n = this.mSize;
            for (int i = 0; i < n; ++i) {
                this.mAccess.setIndex(es[i], -1);
                es[i] = null;
            }
        } else {
            int n = this.mSize;
            for (int i = 0; i < n; ++i) {
                es[i] = null;
            }
        }
        this.mSize = 0;
    }

    @Override
    public E poll() {
        E[] es = this.mHeap;
        E result = es[0];
        if (result != null) {
            int n = --this.mSize;
            E x = es[n];
            es[n] = null;
            if (n > 0) {
                this.siftDown(0, x);
            }
        }
        return result;
    }

    public void removeAt(int i) {
        Objects.checkIndex(i, this.mSize);
        E[] es = this.mHeap;
        int s = --this.mSize;
        if (s == i) {
            if (this.mAccess != null) {
                this.mAccess.setIndex(es[i], -1);
            }
            es[i] = null;
        } else {
            E moved = es[s];
            if (this.mAccess != null) {
                this.mAccess.setIndex(moved, -1);
            }
            es[s] = null;
            this.siftDown(i, moved);
            if (es[i] == moved) {
                this.siftUp(i, moved);
            }
        }
    }

    public E elementAt(int i) {
        return this.mHeap[Objects.checkIndex(i, this.mSize)];
    }

    public void sort() {
        int n = this.mSize;
        if (n > 1) {
            E[] es = this.mHeap;
            Arrays.sort(es, 0, n, this.mComparator);
            Access<E> access = this.mAccess;
            if (access != null) {
                for (int i = 0; i < n; ++i) {
                    access.setIndex(es[i], i);
                }
            }
        }
    }

    public void heap() {
        Access<E> access;
        int i;
        E[] es = this.mHeap;
        int n = this.mSize;
        if (this.mComparator == null) {
            for (i = (n >>> 1) - 1; i >= 0; --i) {
                PriorityQueue.siftDownComparable(i, es[i], es, n);
            }
        } else {
            while (i >= 0) {
                PriorityQueue.siftDownUsingComparator(i, es[i], es, n, this.mComparator);
                --i;
            }
        }
        if ((access = this.mAccess) != null) {
            for (i = 0; i < n; ++i) {
                access.setIndex(es[i], i);
            }
        }
    }

    public void trim() {
        int n = this.mSize;
        E[] es = this.mHeap;
        if (n < es.length) {
            this.mHeap = Arrays.copyOf(es, n);
        }
    }

    private void siftUp(int k, E x) {
        if (this.mComparator != null) {
            if (this.mAccess != null) {
                PriorityQueue.siftUpUsingComparator(k, x, this.mHeap, this.mComparator, this.mAccess);
            } else {
                PriorityQueue.siftUpUsingComparator(k, x, this.mHeap, this.mComparator);
            }
        } else if (this.mAccess != null) {
            PriorityQueue.siftUpComparable(k, x, this.mHeap, this.mAccess);
        } else {
            PriorityQueue.siftUpComparable(k, x, this.mHeap);
        }
    }

    private static <T> void siftUpComparable(int k, T x, T[] es) {
        int parent;
        T e;
        Comparable key = (Comparable)x;
        while (k > 0 && key.compareTo(e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            k = parent;
        }
        es[k] = x;
    }

    private static <T> void siftUpComparable(int k, T x, T[] es, Access<? super T> access) {
        int parent;
        T e;
        Comparable key = (Comparable)x;
        while (k > 0 && key.compareTo(e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            access.setIndex(e, k);
            k = parent;
        }
        es[k] = x;
        access.setIndex(x, k);
    }

    private static <T> void siftUpUsingComparator(int k, T x, T[] es, Comparator<? super T> c) {
        int parent;
        T e;
        while (k > 0 && c.compare(x, e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            k = parent;
        }
        es[k] = x;
    }

    private static <T> void siftUpUsingComparator(int k, T x, T[] es, Comparator<? super T> c, Access<? super T> access) {
        int parent;
        T e;
        while (k > 0 && c.compare(x, e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            access.setIndex(e, k);
            k = parent;
        }
        es[k] = x;
        access.setIndex(x, k);
    }

    private void siftDown(int k, E x) {
        if (this.mComparator != null) {
            if (this.mAccess != null) {
                PriorityQueue.siftDownUsingComparator(k, x, this.mHeap, this.mSize, this.mComparator, this.mAccess);
            } else {
                PriorityQueue.siftDownUsingComparator(k, x, this.mHeap, this.mSize, this.mComparator);
            }
        } else if (this.mAccess != null) {
            PriorityQueue.siftDownComparable(k, x, this.mHeap, this.mSize, this.mAccess);
        } else {
            PriorityQueue.siftDownComparable(k, x, this.mHeap, this.mSize);
        }
    }

    private static <T> void siftDownComparable(int k, T x, T[] es, int n) {
        assert (n > 0);
        Comparable key = (Comparable)x;
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            T c = es[child];
            int right = child + 1;
            if (right < n && ((Comparable)c).compareTo(es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (key.compareTo(c) <= 0) break;
            es[k] = c;
            k = child;
        }
        es[k] = x;
    }

    private static <T> void siftDownComparable(int k, T x, T[] es, int n, Access<? super T> access) {
        assert (n > 0);
        Comparable key = (Comparable)x;
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            T c = es[child];
            int right = child + 1;
            if (right < n && ((Comparable)c).compareTo(es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (key.compareTo(c) <= 0) break;
            es[k] = c;
            access.setIndex(c, k);
            k = child;
        }
        es[k] = x;
        access.setIndex(x, k);
    }

    private static <T> void siftDownUsingComparator(int k, T x, T[] es, int n, Comparator<? super T> cmp) {
        assert (n > 0);
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            T c = es[child];
            int right = child + 1;
            if (right < n && cmp.compare(c, es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (cmp.compare(x, c) <= 0) break;
            es[k] = c;
            k = child;
        }
        es[k] = x;
    }

    private static <T> void siftDownUsingComparator(int k, T x, T[] es, int n, Comparator<? super T> cmp, Access<? super T> access) {
        assert (n > 0);
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            T c = es[child];
            int right = child + 1;
            if (right < n && cmp.compare(c, es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (cmp.compare(x, c) <= 0) break;
            es[k] = c;
            access.setIndex(c, k);
            k = child;
        }
        es[k] = x;
        access.setIndex(x, k);
    }

    public Comparator<? super E> comparator() {
        return this.mComparator;
    }

    public Access<? super E> access() {
        return this.mAccess;
    }

    public static interface Access<E> {
        public void setIndex(E var1, int var2);

        public int getIndex(E var1);
    }

    private final class Itr
    implements Iterator<E> {
        private int mCursor;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.mCursor < PriorityQueue.this.mSize;
        }

        @Override
        public E next() {
            if (this.mCursor < PriorityQueue.this.mSize) {
                return PriorityQueue.this.mHeap[this.mCursor++];
            }
            throw new NoSuchElementException();
        }
    }
}

