/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.RefCnt;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import org.lwjgl.system.NativeType;

public class Pixels
extends RefCnt {
    protected final int mWidth;
    protected final int mHeight;
    protected final Object mBase;
    protected final long mAddress;
    protected final int mRowBytes;
    protected final LongConsumer mFreeFn;
    protected boolean mImmutable;

    public Pixels(int width, int height, @Nullable Object base, @NativeType(value="void *") long address, int rowBytes, @Nullable LongConsumer freeFn) {
        this.mWidth = width;
        this.mHeight = height;
        this.mBase = base;
        this.mAddress = address;
        this.mRowBytes = rowBytes;
        this.mFreeFn = freeFn;
    }

    @Override
    protected void deallocate() {
        if (this.mFreeFn != null) {
            this.mFreeFn.accept(this.mAddress);
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    @Nullable
    public Object getBase() {
        return this.mBase;
    }

    public long getAddress() {
        return this.mAddress;
    }

    public int getRowBytes() {
        return this.mRowBytes;
    }

    public boolean isImmutable() {
        return this.mImmutable;
    }

    public void setImmutable() {
        this.mImmutable = true;
    }

    public String toString() {
        return "Pixels{mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + ", mBase=" + this.mBase + ", mAddress=0x" + Long.toHexString(this.mAddress) + ", mRowBytes=" + this.mRowBytes + ", mImmutable=" + this.mImmutable + "}";
    }
}

