/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrix4;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.NativeType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Matrixc {
    public static final int kIdentity_Mask = 0;
    public static final int kTranslate_Mask = 1;
    public static final int kScale_Mask = 2;
    public static final int kAffine_Mask = 4;
    public static final int kPerspective_Mask = 8;

    public int getType();

    public boolean isIdentity();

    public boolean isScaleTranslate();

    public boolean isTranslate();

    public boolean isAxisAligned();

    public boolean preservesRightAngles();

    public boolean hasPerspective();

    public boolean isSimilarity();

    public float m11();

    public float m12();

    public float m14();

    public float m21();

    public float m22();

    public float m24();

    public float m41();

    public float m42();

    public float m44();

    public float getScaleX();

    public float getScaleY();

    public float getShearY();

    public float getShearX();

    public float getTranslateX();

    public float getTranslateY();

    public float getPerspX();

    public float getPerspY();

    public void store(@Nonnull Matrix var1);

    public void store(@Nonnull float[] var1);

    public void store(@Nonnull float[] var1, int var2);

    public void store(@Nonnull ByteBuffer var1);

    public void storeAligned(@Nonnull ByteBuffer var1);

    public void store(@Nonnull FloatBuffer var1);

    public void storeAligned(@Nonnull FloatBuffer var1);

    public void store(@NativeType(value="void *") long var1);

    public void storeAligned(@NativeType(value="void *") long var1);

    public void toMatrix4(@Nonnull Matrix4 var1);

    @Nonnull
    public Matrix4 toMatrix4();

    public boolean invert(@Nullable Matrix var1);

    default public boolean mapRect(@Nonnull Rect2f rect) {
        return this.mapRect((Rect2fc)rect, rect);
    }

    public boolean mapRect(@Nonnull Rect2fc var1, @Nonnull Rect2f var2);

    default public void mapRect(@Nonnull Rect2i r) {
        this.mapRect(r.mLeft, r.mTop, r.mRight, r.mBottom, r);
    }

    default public void mapRect(@Nonnull Rect2fc r, @Nonnull Rect2i out) {
        this.mapRect(r.left(), r.top(), r.right(), r.bottom(), out);
    }

    default public void mapRect(@Nonnull Rect2ic r, @Nonnull Rect2i out) {
        this.mapRect(r.left(), r.top(), r.right(), r.bottom(), out);
    }

    public void mapRect(float var1, float var2, float var3, float var4, @Nonnull Rect2i var5);

    default public void mapRectOut(@Nonnull Rect2i r) {
        this.mapRectOut(r.mLeft, r.mTop, r.mRight, r.mBottom, r);
    }

    default public void mapRectOut(@Nonnull Rect2ic r, @Nonnull Rect2i dst) {
        this.mapRectOut(r.left(), r.top(), r.right(), r.bottom(), dst);
    }

    default public void mapRectOut(@Nonnull Rect2fc r, @Nonnull Rect2i dst) {
        this.mapRectOut(r.left(), r.top(), r.right(), r.bottom(), dst);
    }

    public void mapRectOut(float var1, float var2, float var3, float var4, @Nonnull Rect2i var5);

    default public void mapPoint(float[] p) {
        this.mapPoints(p, 0, p, 0, 1);
    }

    default public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    default public void mapPoints(float[] pts, int count) {
        this.mapPoints(pts, 0, pts, 0, count);
    }

    default public void mapPoints(float[] pts, int pos, int count) {
        this.mapPoints(pts, pos, pts, pos, count);
    }

    default public void mapPoints(float[] src, float[] dst, int count) {
        this.mapPoints(src, 0, dst, 0, count);
    }

    public void mapPoints(float[] var1, int var2, float[] var3, int var4, int var5);

    public float getMinScale();

    public float getMaxScale();

    public float getMinScale(float var1, float var2);

    public float getMaxScale(float var1, float var2);

    public float differentialAreaScale(float var1, float var2);

    public float localAARadius(Rect2fc var1);

    public float localAARadius(float var1, float var2, float var3, float var4);

    public boolean isFinite();

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();

    @Nonnull
    public Matrix clone();
}

