/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.GlyphRun;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.TextBlob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class GlyphRunList {
    public GlyphRun[] mGlyphRuns;
    public int mGlyphRunCount;
    public TextBlob mOriginalTextBlob;
    private final Rect2f mSourceBounds = new Rect2f();
    public float mOriginX;
    public float mOriginY;

    public void set(GlyphRun[] glyphRuns, int glyphRunCount, @Nullable TextBlob blob, Rect2fc bounds, float originX, float originY) {
        this.mGlyphRuns = glyphRuns;
        this.mGlyphRunCount = glyphRunCount;
        this.mOriginalTextBlob = blob;
        this.mSourceBounds.set(bounds);
        this.mOriginX = originX;
        this.mOriginY = originY;
    }

    @Nonnull
    public Rect2fc getSourceBounds() {
        return this.mSourceBounds;
    }

    public void getSourceBoundsWithOrigin(@Nonnull Rect2f bounds) {
        this.mSourceBounds.store(bounds);
        bounds.offset(this.mOriginX, this.mOriginY);
    }

    public int maxGlyphRunSize() {
        int size = 0;
        for (int i = 0; i < this.mGlyphRunCount; ++i) {
            size = Math.max(this.mGlyphRuns[i].mGlyphCount, size);
        }
        return size;
    }

    public void clear() {
        if (this.mGlyphRuns != null) {
            for (int i = 0; i < this.mGlyphRunCount; ++i) {
                this.mGlyphRuns[i].clear();
            }
            this.mGlyphRuns = null;
        }
        this.mOriginalTextBlob = null;
    }
}

