/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Blender;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Size;
import javax.annotation.Nonnull;

public enum BlendMode implements Blender
{
    CLEAR,
    SRC,
    DST,
    SRC_OVER,
    DST_OVER,
    SRC_IN,
    DST_IN,
    SRC_OUT,
    DST_OUT,
    SRC_ATOP,
    DST_ATOP,
    XOR,
    PLUS,
    PLUS_CLAMPED,
    MINUS,
    MINUS_CLAMPED,
    MODULATE,
    MULTIPLY,
    SCREEN,
    OVERLAY,
    DARKEN,
    LIGHTEN,
    COLOR_DODGE,
    COLOR_BURN,
    HARD_LIGHT,
    SOFT_LIGHT,
    DIFFERENCE,
    EXCLUSION,
    SUBTRACT,
    DIVIDE,
    LINEAR_DODGE,
    LINEAR_BURN,
    VIVID_LIGHT,
    LINEAR_LIGHT,
    PIN_LIGHT,
    HARD_MIX,
    DARKER_COLOR,
    LIGHTER_COLOR,
    HUE,
    SATURATION,
    COLOR,
    LUMINOSITY;

    public static final BlendMode ADD;
    private static final BlendMode[] VALUES;
    public static final int COUNT;

    @Nonnull
    public static BlendMode modeAt(int index) {
        return VALUES[index];
    }

    @Override
    public void ref() {
    }

    @Override
    public void unref() {
    }

    @Override
    public BlendMode asBlendMode() {
        return this;
    }

    public boolean isAdvanced() {
        return this.ordinal() >= MULTIPLY.ordinal();
    }

    public String getBlendFuncName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case CLEAR -> "blend_clear";
            case SRC -> "blend_src";
            case DST -> "blend_dst";
            case SRC_OVER -> "blend_src_over";
            case DST_OVER -> "blend_dst_over";
            case SRC_IN -> "blend_src_in";
            case DST_IN -> "blend_dst_in";
            case SRC_OUT -> "blend_src_out";
            case DST_OUT -> "blend_dst_out";
            case SRC_ATOP -> "blend_src_atop";
            case DST_ATOP -> "blend_dst_atop";
            case XOR -> "blend_xor";
            case PLUS -> "blend_plus";
            case PLUS_CLAMPED -> "blend_plus_clamped";
            case MINUS -> "blend_minus";
            case MINUS_CLAMPED -> "blend_minus_clamped";
            case MODULATE -> "blend_modulate";
            case MULTIPLY -> "blend_multiply";
            case SCREEN -> "blend_screen";
            case OVERLAY -> "blend_overlay";
            case DARKEN -> "blend_darken";
            case LIGHTEN -> "blend_lighten";
            case COLOR_DODGE -> "blend_color_dodge";
            case COLOR_BURN -> "blend_color_burn";
            case HARD_LIGHT -> "blend_hard_light";
            case SOFT_LIGHT -> "blend_soft_light";
            case DIFFERENCE -> "blend_difference";
            case EXCLUSION -> "blend_exclusion";
            case SUBTRACT -> "blend_subtract";
            case DIVIDE -> "blend_divide";
            case LINEAR_DODGE -> "blend_linear_dodge";
            case LINEAR_BURN -> "blend_linear_burn";
            case VIVID_LIGHT -> "blend_vivid_light";
            case LINEAR_LIGHT -> "blend_linear_light";
            case PIN_LIGHT -> "blend_pin_light";
            case HARD_MIX -> "blend_hard_mix";
            case DARKER_COLOR -> "blend_darker_color";
            case LIGHTER_COLOR -> "blend_lighter_color";
            case HUE -> "blend_hue";
            case SATURATION -> "blend_saturation";
            case COLOR -> "blend_color";
            case LUMINOSITY -> "blend_luminosity";
        };
    }

    public final void apply(@Size(value=4L) float[] src, @Size(value=4L) float[] dst, @Size(value=4L) float[] out) {
        switch (this) {
            case CLEAR: {
                for (int i = 0; i < 4; ++i) {
                    out[i] = 0.0f;
                }
                break;
            }
            case SRC: {
                System.arraycopy(src, 0, out, 0, 4);
                break;
            }
            case DST: {
                System.arraycopy(dst, 0, out, 0, 4);
                break;
            }
            case SRC_OVER: {
                BlendMode.blend_src_over(src, dst, out);
                break;
            }
            case DST_OVER: {
                BlendMode.blend_dst_over(src, dst, out);
                break;
            }
            case SRC_IN: {
                BlendMode.blend_src_in(src, dst, out);
                break;
            }
            case DST_IN: {
                BlendMode.blend_dst_in(src, dst, out);
                break;
            }
            case SRC_OUT: {
                BlendMode.blend_src_out(src, dst, out);
                break;
            }
            case DST_OUT: {
                BlendMode.blend_dst_out(src, dst, out);
                break;
            }
            case SRC_ATOP: {
                BlendMode.blend_src_atop(src, dst, out);
                break;
            }
            case DST_ATOP: {
                BlendMode.blend_dst_atop(src, dst, out);
                break;
            }
            case XOR: {
                BlendMode.blend_xor(src, dst, out);
                break;
            }
            case PLUS: {
                BlendMode.blend_plus(src, dst, out);
                break;
            }
            case PLUS_CLAMPED: {
                BlendMode.blend_plus_clamped(src, dst, out);
                break;
            }
            case MINUS: {
                BlendMode.blend_minus(src, dst, out);
                break;
            }
            case MINUS_CLAMPED: {
                BlendMode.blend_minus_clamped(src, dst, out);
                break;
            }
            case MODULATE: {
                BlendMode.blend_modulate(src, dst, out);
                break;
            }
            case MULTIPLY: {
                BlendMode.blend_multiply(src, dst, out);
                break;
            }
            case SCREEN: {
                BlendMode.blend_screen(src, dst, out);
                break;
            }
            case OVERLAY: {
                BlendMode.blend_overlay(src, dst, out);
                break;
            }
            case DARKEN: {
                BlendMode.blend_darken(src, dst, out);
                break;
            }
            case LIGHTEN: {
                BlendMode.blend_lighten(src, dst, out);
                break;
            }
            case COLOR_DODGE: {
                BlendMode.blend_color_dodge(src, dst, out);
                break;
            }
            case COLOR_BURN: {
                BlendMode.blend_color_burn(src, dst, out);
                break;
            }
            case HARD_LIGHT: {
                BlendMode.blend_hard_light(src, dst, out);
                break;
            }
            case SOFT_LIGHT: {
                BlendMode.blend_soft_light(src, dst, out);
                break;
            }
            case DIFFERENCE: {
                BlendMode.blend_difference(src, dst, out);
                break;
            }
            case EXCLUSION: {
                BlendMode.blend_exclusion(src, dst, out);
                break;
            }
            case SUBTRACT: {
                BlendMode.blend_subtract(src, dst, out);
                break;
            }
            case DIVIDE: {
                BlendMode.blend_divide(src, dst, out);
                break;
            }
            case LINEAR_DODGE: {
                BlendMode.blend_linear_dodge(src, dst, out);
                break;
            }
            case LINEAR_BURN: {
                BlendMode.blend_linear_burn(src, dst, out);
                break;
            }
            case VIVID_LIGHT: {
                BlendMode.blend_vivid_light(src, dst, out);
                break;
            }
            case LINEAR_LIGHT: {
                BlendMode.blend_linear_light(src, dst, out);
                break;
            }
            case PIN_LIGHT: {
                BlendMode.blend_pin_light(src, dst, out);
                break;
            }
            case HARD_MIX: {
                BlendMode.blend_hard_mix(src, dst, out);
                break;
            }
            case DARKER_COLOR: {
                BlendMode.blend_darker_color(src, dst, out);
                break;
            }
            case LIGHTER_COLOR: {
                BlendMode.blend_lighter_color(src, dst, out);
                break;
            }
            case HUE: {
                BlendMode.blend_hue(src, dst, out);
                break;
            }
            case SATURATION: {
                BlendMode.blend_saturation(src, dst, out);
                break;
            }
            case COLOR: {
                BlendMode.blend_color(src, dst, out);
                break;
            }
            case LUMINOSITY: {
                BlendMode.blend_luminosity(src, dst, out);
            }
        }
    }

    public static void blend_src_over(float[] src, float[] dst, float[] out) {
        float df = 1.0f - src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] + dst[i] * df;
        }
    }

    public static void blend_dst_over(float[] src, float[] dst, float[] out) {
        float sf = 1.0f - dst[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * sf + dst[i];
        }
    }

    public static void blend_src_in(float[] src, float[] dst, float[] out) {
        float sf = dst[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * sf;
        }
    }

    public static void blend_dst_in(float[] src, float[] dst, float[] out) {
        float df = src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = dst[i] * df;
        }
    }

    public static void blend_src_out(float[] src, float[] dst, float[] out) {
        float sf = 1.0f - dst[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * sf;
        }
    }

    public static void blend_dst_out(float[] src, float[] dst, float[] out) {
        float df = 1.0f - src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = dst[i] * df;
        }
    }

    public static void blend_src_atop(float[] src, float[] dst, float[] out) {
        float sf = dst[3];
        float df = 1.0f - src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * sf + dst[i] * df;
        }
    }

    public static void blend_dst_atop(float[] src, float[] dst, float[] out) {
        float sf = 1.0f - dst[3];
        float df = src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * sf + dst[i] * df;
        }
    }

    public static void blend_xor(float[] src, float[] dst, float[] out) {
        float sf = 1.0f - dst[3];
        float df = 1.0f - src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * sf + dst[i] * df;
        }
    }

    public static void blend_plus(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] + dst[i];
        }
    }

    public static void blend_plus_clamped(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = Math.min(src[i] + dst[i], 1.0f);
        }
    }

    public static void blend_minus(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = dst[i] - src[i];
        }
    }

    public static void blend_minus_clamped(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = Math.max(dst[i] - src[i], 0.0f);
        }
    }

    public static void blend_modulate(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * dst[i];
        }
    }

    public static void blend_multiply(float[] src, float[] dst, float[] out) {
        float sf = 1.0f - dst[3];
        float df = 1.0f - src[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] * dst[i] + src[i] * sf + dst[i] * df;
        }
    }

    public static void blend_screen(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] + dst[i] - src[i] * dst[i];
        }
    }

    public static void blend_overlay(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = src[i] * (1.0f - da) + dst[i] * (1.0f - sa) + (2.0f * dst[i] <= da ? 2.0f * src[i] * dst[i] : sa * da - 2.0f * (sa - src[i]) * (da - dst[i]));
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_darken(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] + dst[i] - Math.max(src[i] * da, dst[i] * sa);
        }
    }

    public static void blend_lighten(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 4; ++i) {
            out[i] = src[i] + dst[i] - Math.min(src[i] * da, dst[i] * sa);
        }
    }

    public static void blend_color_dodge(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float s = src[i];
            float d = dst[i];
            out[i] = d <= 0.0f ? s * (1.0f - da) : (s >= sa ? sa * da + s * (1.0f - da) + d * (1.0f - sa) : sa * Math.min(da, d * sa / (sa - s)) + s * (1.0f - da) + d * (1.0f - sa));
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_color_burn(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float s = src[i];
            float d = dst[i];
            out[i] = d >= da ? sa * da + s * (1.0f - da) + d * (1.0f - sa) : (s <= 0.0f ? d * (1.0f - sa) : sa * Math.max(0.0f, da - (da - d) * sa / s) + s * (1.0f - da) + d * (1.0f - sa));
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_hard_light(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = src[i] * (1.0f - da) + dst[i] * (1.0f - sa) + (2.0f * src[i] <= sa ? 2.0f * src[i] * dst[i] : sa * da - 2.0f * (sa - src[i]) * (da - dst[i]));
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_soft_light(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float s = src[i];
            float d = dst[i];
            if (2.0f * s <= sa) {
                out[i] = d * d * (sa - 2.0f * s) / da + s * (1.0f - da) + d * (2.0f * s + 1.0f - sa);
                continue;
            }
            if (4.0f * d <= da) {
                float dd = d * d;
                float dada = da * da;
                out[i] = (dada * (s + d * (6.0f * s - 3.0f * sa + 1.0f)) + 12.0f * da * dd * (sa - 2.0f * s) - 16.0f * dd * d * (sa - 2.0f * s) - dada * da * s) / dada;
                continue;
            }
            out[i] = d * (sa - 2.0f * s + 1.0f) + s * (1.0f - da) - (float)Math.sqrt(d * da) * (sa - 2.0f * s);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_difference(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = src[i] + dst[i] - 2.0f * Math.min(src[i] * da, dst[i] * sa);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_exclusion(float[] src, float[] dst, float[] out) {
        for (int i = 0; i < 3; ++i) {
            out[i] = src[i] + dst[i] - 2.0f * (src[i] * dst[i]);
        }
        out[3] = src[3] + dst[3] * (1.0f - src[3]);
    }

    public static void blend_subtract(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = src[i] * (1.0f - da) + dst[i] - Math.min(src[i] * da, dst[i] * sa);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_divide(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = MathUtil.pin(dst[i] * sa / (src[i] * da), 0.0f, 1.0f) * sa * da + src[i] * (1.0f - da) + dst[i] * (1.0f - sa);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_linear_dodge(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = Math.min(src[i] + dst[i], sa * da + src[i] * (1.0f - da) + dst[i] * (1.0f - sa));
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_linear_burn(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = Math.max(src[i] + dst[i] - sa * da, src[i] * (1.0f - da) + dst[i] * (1.0f - sa));
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_vivid_light(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float s = src[i];
            float d = dst[i];
            if (2.0f * s < sa) {
                if (s <= 0.0f) {
                    out[i] = d * (1.0f - sa);
                    continue;
                }
                out[i] = sa * Math.max(0.0f, da - (da - d) * sa / (2.0f * s)) + s * (1.0f - da) + d * (1.0f - sa);
                continue;
            }
            out[i] = s >= sa ? sa * da + s * (1.0f - da) + d * (1.0f - sa) : sa * Math.min(da, d * sa / (2.0f * (sa - s))) + s * (1.0f - da) + d * (1.0f - sa);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_linear_light(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float s = src[i];
            float d = dst[i];
            out[i] = MathUtil.clamp(2.0f * s * da + d * sa - sa * da, 0.0f, sa * da) + s * (1.0f - da) + d * (1.0f - sa);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_pin_light(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float x = 2.0f * src[i] * da;
            float y = x - sa * da;
            float z = dst[i] * sa;
            out[i] = (y > z ? (2.0f * src[i] < sa ? 0.0f : y) : Math.min(x, z)) + src[i] * (1.0f - da) + dst[i] * (1.0f - sa);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_hard_mix(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        for (int i = 0; i < 3; ++i) {
            float b = src[i] * da + dst[i] * sa;
            float c = sa * da;
            out[i] = src[i] + dst[i] - b + (b < c ? 0.0f : c);
        }
        out[3] = sa + da * (1.0f - sa);
    }

    public static void blend_darker_color(float[] src, float[] dst, float[] out) {
        if (BlendMode.lum(src) <= BlendMode.lum(dst)) {
            float df = 1.0f - src[3];
            for (int i = 0; i < 4; ++i) {
                out[i] = src[i] + dst[i] * df;
            }
        } else {
            float sf = 1.0f - dst[3];
            for (int i = 0; i < 4; ++i) {
                out[i] = src[i] * sf + dst[i];
            }
        }
    }

    public static void blend_lighter_color(float[] src, float[] dst, float[] out) {
        if (BlendMode.lum(src) >= BlendMode.lum(dst)) {
            float df = 1.0f - src[3];
            for (int i = 0; i < 4; ++i) {
                out[i] = src[i] + dst[i] * df;
            }
        } else {
            float sf = 1.0f - dst[3];
            for (int i = 0; i < 4; ++i) {
                out[i] = src[i] * sf + dst[i];
            }
        }
    }

    public static void blend_hue(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        float alpha = sa * da;
        float[] c = new float[]{src[0] * da, src[1] * da, src[2] * da};
        BlendMode.set_lum_sat(c, dst, sa, dst, sa, alpha);
        for (int i = 0; i < 3; ++i) {
            out[i] = c[i] + src[i] * (1.0f - da) + dst[i] * (1.0f - sa);
        }
        out[3] = sa + da - alpha;
    }

    public static void blend_saturation(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        float alpha = sa * da;
        float[] c = new float[]{dst[0] * sa, dst[1] * sa, dst[2] * sa};
        BlendMode.set_lum_sat(c, src, da, dst, sa, alpha);
        for (int i = 0; i < 3; ++i) {
            out[i] = c[i] + src[i] * (1.0f - da) + dst[i] * (1.0f - sa);
        }
        out[3] = sa + da - alpha;
    }

    public static void blend_color(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        float alpha = sa * da;
        float[] c = new float[]{src[0] * da, src[1] * da, src[2] * da};
        BlendMode.set_lum(c, dst, sa, alpha);
        for (int i = 0; i < 3; ++i) {
            out[i] = c[i] + src[i] * (1.0f - da) + dst[i] * (1.0f - sa);
        }
        out[3] = sa + da - alpha;
    }

    public static void blend_luminosity(float[] src, float[] dst, float[] out) {
        float sa = src[3];
        float da = dst[3];
        float alpha = sa * da;
        float[] c = new float[]{dst[0] * sa, dst[1] * sa, dst[2] * sa};
        BlendMode.set_lum(c, src, da, alpha);
        for (int i = 0; i < 3; ++i) {
            out[i] = c[i] + src[i] * (1.0f - da) + dst[i] * (1.0f - sa);
        }
        out[3] = sa + da - alpha;
    }

    private static float lum(float[] c) {
        return 0.299f * c[0] + 0.587f * c[1] + 0.114f * c[2];
    }

    private static void set_lum(float[] cbase, float[] clum, float alum, float alpha) {
        int i;
        float ldiff = BlendMode.lum(clum) * alum - BlendMode.lum(cbase);
        int i2 = 0;
        while (i2 < 3) {
            int n = i2++;
            cbase[n] = cbase[n] + ldiff;
        }
        float lum = BlendMode.lum(cbase);
        float mincol = MathUtil.min3(cbase);
        float maxcol = MathUtil.max3(cbase);
        if (mincol < 0.0f && lum != mincol) {
            for (i = 0; i < 3; ++i) {
                cbase[i] = lum + (cbase[i] - lum) * lum / (lum - mincol);
            }
        }
        if (maxcol > alpha && maxcol != lum) {
            for (i = 0; i < 3; ++i) {
                cbase[i] = lum + (cbase[i] - lum) * (alpha - lum) / (maxcol - lum);
            }
        }
    }

    private static void set_lum_sat(float[] cbase, float[] csat, float asat, float[] clum, float alum, float alpha) {
        float minbase = MathUtil.min3(cbase);
        float sbase = MathUtil.max3(cbase) - minbase;
        if (sbase > 0.0f) {
            float ssat = (MathUtil.max3(csat) - MathUtil.min3(csat)) * asat;
            for (int i = 0; i < 3; ++i) {
                cbase[i] = (cbase[i] - minbase) * ssat / sbase;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                cbase[i] = 0.0f;
            }
        }
        BlendMode.set_lum(cbase, clum, alum, alpha);
    }

    static {
        ADD = LINEAR_DODGE;
        VALUES = BlendMode.values();
        COUNT = VALUES.length;
    }
}

