/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Position;
import icyllis.arc3d.compiler.tree.AnonymousField;
import icyllis.arc3d.compiler.tree.BinaryExpression;
import icyllis.arc3d.compiler.tree.BlockStatement;
import icyllis.arc3d.compiler.tree.BreakStatement;
import icyllis.arc3d.compiler.tree.ConditionalExpression;
import icyllis.arc3d.compiler.tree.ConstructorArray;
import icyllis.arc3d.compiler.tree.ConstructorArrayCast;
import icyllis.arc3d.compiler.tree.ConstructorCompound;
import icyllis.arc3d.compiler.tree.ConstructorCompoundCast;
import icyllis.arc3d.compiler.tree.ConstructorDiagonalMatrix;
import icyllis.arc3d.compiler.tree.ConstructorMatrixResize;
import icyllis.arc3d.compiler.tree.ConstructorScalarCast;
import icyllis.arc3d.compiler.tree.ConstructorStruct;
import icyllis.arc3d.compiler.tree.ConstructorVectorSplat;
import icyllis.arc3d.compiler.tree.ContinueStatement;
import icyllis.arc3d.compiler.tree.DiscardStatement;
import icyllis.arc3d.compiler.tree.EmptyStatement;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.ExpressionStatement;
import icyllis.arc3d.compiler.tree.FieldAccess;
import icyllis.arc3d.compiler.tree.ForLoop;
import icyllis.arc3d.compiler.tree.FunctionCall;
import icyllis.arc3d.compiler.tree.FunctionDecl;
import icyllis.arc3d.compiler.tree.FunctionDefinition;
import icyllis.arc3d.compiler.tree.FunctionPrototype;
import icyllis.arc3d.compiler.tree.FunctionReference;
import icyllis.arc3d.compiler.tree.GlobalVariableDecl;
import icyllis.arc3d.compiler.tree.IfStatement;
import icyllis.arc3d.compiler.tree.IndexExpression;
import icyllis.arc3d.compiler.tree.InterfaceBlock;
import icyllis.arc3d.compiler.tree.Literal;
import icyllis.arc3d.compiler.tree.Poison;
import icyllis.arc3d.compiler.tree.PostfixExpression;
import icyllis.arc3d.compiler.tree.PrefixExpression;
import icyllis.arc3d.compiler.tree.ReturnStatement;
import icyllis.arc3d.compiler.tree.Statement;
import icyllis.arc3d.compiler.tree.StructDefinition;
import icyllis.arc3d.compiler.tree.SwitchCase;
import icyllis.arc3d.compiler.tree.SwitchStatement;
import icyllis.arc3d.compiler.tree.Swizzle;
import icyllis.arc3d.compiler.tree.Symbol;
import icyllis.arc3d.compiler.tree.TopLevelElement;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import icyllis.arc3d.compiler.tree.Type;
import icyllis.arc3d.compiler.tree.TypeReference;
import icyllis.arc3d.compiler.tree.Variable;
import icyllis.arc3d.compiler.tree.VariableDecl;
import icyllis.arc3d.compiler.tree.VariableReference;
import javax.annotation.Nonnull;

public abstract class Node {
    public int mPosition;

    protected Node(int position) {
        this.mPosition = position;
    }

    public final int getStartOffset() {
        assert (this.mPosition != -1);
        return Position.getStartOffset(this.mPosition);
    }

    public final int getEndOffset() {
        assert (this.mPosition != -1);
        return Position.getEndOffset(this.mPosition);
    }

    public abstract boolean accept(@Nonnull TreeVisitor var1);

    @Nonnull
    public abstract String toString();

    public static enum ExpressionKind {
        BINARY(BinaryExpression.class),
        CONDITIONAL(ConditionalExpression.class),
        CONSTRUCTOR_ARRAY(ConstructorArray.class),
        CONSTRUCTOR_ARRAY_CAST(ConstructorArrayCast.class),
        CONSTRUCTOR_COMPOUND(ConstructorCompound.class),
        CONSTRUCTOR_COMPOUND_CAST(ConstructorCompoundCast.class),
        CONSTRUCTOR_DIAGONAL_MATRIX(ConstructorDiagonalMatrix.class),
        CONSTRUCTOR_MATRIX_RESIZE(ConstructorMatrixResize.class),
        CONSTRUCTOR_SCALAR_CAST(ConstructorScalarCast.class),
        CONSTRUCTOR_STRUCT(ConstructorStruct.class),
        CONSTRUCTOR_VECTOR_SPLAT(ConstructorVectorSplat.class),
        FIELD_ACCESS(FieldAccess.class),
        FUNCTION_CALL(FunctionCall.class),
        FUNCTION_REFERENCE(FunctionReference.class),
        INDEX(IndexExpression.class),
        LITERAL(Literal.class),
        POISON(Poison.class),
        POSTFIX(PostfixExpression.class),
        PREFIX(PrefixExpression.class),
        SWIZZLE(Swizzle.class),
        TYPE_REFERENCE(TypeReference.class),
        VARIABLE_REFERENCE(VariableReference.class);

        private final Class<? extends Expression> mType;

        private ExpressionKind(Class<? extends Expression> type) {
            this.mType = type;
        }

        public Class<? extends Expression> getType() {
            return this.mType;
        }
    }

    public static enum StatementKind {
        BLOCK(BlockStatement.class),
        BREAK(BreakStatement.class),
        CONTINUE(ContinueStatement.class),
        DISCARD(DiscardStatement.class),
        DO_LOOP(Statement.class),
        EMPTY(EmptyStatement.class),
        EXPRESSION(ExpressionStatement.class),
        FOR_LOOP(ForLoop.class),
        IF(IfStatement.class),
        RETURN(ReturnStatement.class),
        SWITCH(SwitchStatement.class),
        SWITCH_CASE(SwitchCase.class),
        VARIABLE_DECL(VariableDecl.class);

        private final Class<? extends Statement> mType;

        private StatementKind(Class<? extends Statement> type) {
            this.mType = type;
        }

        public Class<? extends Statement> getType() {
            return this.mType;
        }
    }

    public static enum SymbolKind {
        ANONYMOUS_FIELD(AnonymousField.class),
        FUNCTION_DECL(FunctionDecl.class),
        TYPE(Type.class),
        VARIABLE(Variable.class);

        private final Class<? extends Symbol> mType;

        private SymbolKind(Class<? extends Symbol> type) {
            this.mType = type;
        }

        public Class<? extends Symbol> getType() {
            return this.mType;
        }
    }

    public static enum ElementKind {
        EXTENSION(TopLevelElement.class),
        FUNCTION_DEFINITION(FunctionDefinition.class),
        FUNCTION_PROTOTYPE(FunctionPrototype.class),
        GLOBAL_VARIABLE(GlobalVariableDecl.class),
        INTERFACE_BLOCK(InterfaceBlock.class),
        MODIFIERS(TopLevelElement.class),
        STRUCT_DEFINITION(StructDefinition.class);

        private final Class<? extends TopLevelElement> mType;

        private ElementKind(Class<? extends TopLevelElement> type) {
            this.mType = type;
        }

        public Class<? extends TopLevelElement> getType() {
            return this.mType;
        }
    }
}

