/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.Layout;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

public final class Modifiers
extends Node {
    public static final int kSmooth_Flag = 1;
    public static final int kFlat_Flag = 2;
    public static final int kNoPerspective_Flag = 4;
    public static final int kConst_Flag = 8;
    public static final int kUniform_Flag = 16;
    public static final int kIn_Flag = 32;
    public static final int kOut_Flag = 64;
    public static final int kCoherent_Flag = 128;
    public static final int kVolatile_Flag = 256;
    public static final int kRestrict_Flag = 512;
    public static final int kReadOnly_Flag = 1024;
    public static final int kWriteOnly_Flag = 2048;
    public static final int kBuffer_Flag = 4096;
    public static final int kWorkgroup_Flag = 8192;
    public static final int kSubroutine_Flag = 16384;
    public static final int kPure_Flag = 32768;
    public static final int kInline_Flag = 65536;
    public static final int kNoInline_Flag = 131072;
    public static final int kCount_Flag = 18;
    public static final int kInterpolation_Flags = 7;
    public static final int kMemory_Flags = 3968;
    public static final int kStorage_Flags = 12400;
    private Layout mLayout = null;
    private int mFlags = 0;

    public static String describeFlag(int flag) {
        assert (Integer.bitCount(flag) == 1);
        return switch (Integer.numberOfTrailingZeros(flag)) {
            case 0 -> "smooth";
            case 1 -> "flat";
            case 2 -> "noperspective";
            case 3 -> "const";
            case 4 -> "uniform";
            case 5 -> "in";
            case 6 -> "out";
            case 7 -> "coherent";
            case 8 -> "volatile";
            case 9 -> "restrict";
            case 10 -> "readonly";
            case 11 -> "writeonly";
            case 12 -> "buffer";
            case 13 -> "workgroup";
            case 14 -> "subroutine";
            case 15 -> "__pure";
            case 16 -> "inline";
            case 17 -> "noinline";
            default -> "";
        };
    }

    public Modifiers(int position) {
        super(position);
    }

    public Layout layout() {
        return this.mLayout;
    }

    public int layoutFlags() {
        return this.mLayout != null ? this.mLayout.layoutFlags() : 0;
    }

    public void setLayoutFlag(@Nonnull Context context, int mask, String name, int pos) {
        Layout layout = this.mLayout;
        if (layout == null) {
            layout = this.mLayout = new Layout();
        }
        layout.setLayoutFlag(context, mask, name, pos);
    }

    public void clearLayoutFlag(int mask) {
        if (this.mLayout != null) {
            this.mLayout.clearLayoutFlag(mask);
        }
    }

    public boolean checkLayoutFlags(@Nonnull Context context, int permittedLayoutFlags) {
        if (this.mLayout != null) {
            return this.mLayout.checkLayoutFlags(context, this.mPosition, permittedLayoutFlags);
        }
        return true;
    }

    public int flags() {
        return this.mFlags;
    }

    public void setFlag(@Nonnull Context context, int mask, int pos) {
        if ((this.mFlags & mask) != 0) {
            context.error(pos, "qualifier '" + Modifiers.describeFlags(this.mFlags & mask) + "' appears more than once");
        }
        this.mFlags |= mask;
    }

    public void clearFlag(int mask) {
        this.mFlags &= ~mask;
    }

    public boolean checkFlags(@Nonnull Context context, int permittedFlags) {
        boolean success = true;
        for (int i = 0; i < 18; ++i) {
            int flag = 1 << i;
            if ((this.mFlags & flag) == 0 || (permittedFlags & flag) != 0) continue;
            context.error(this.mPosition, "qualifier '" + Modifiers.describeFlag(flag) + "' is not permitted here");
            success = false;
        }
        if (Integer.bitCount(this.mFlags & 7) > 1) {
            context.error(this.mPosition, "at most one interpolation qualifier can be used");
            success = false;
        }
        return success;
    }

    public boolean isConst() {
        return (this.mFlags & 8) != 0;
    }

    public boolean isUniform() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean isBuffer() {
        return (this.mFlags & 0x1000) != 0;
    }

    public int layoutOffset() {
        return this.mLayout != null ? this.mLayout.mOffset : -1;
    }

    public int layoutBuiltin() {
        return this.mLayout != null ? this.mLayout.mBuiltin : -1;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.mLayout);
        result = 31 * result + this.mFlags;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Modifiers modifiers = (Modifiers)o;
        return this.mFlags == modifiers.mFlags && Objects.equals(this.mLayout, modifiers.mLayout);
    }

    @Override
    @Nonnull
    public String toString() {
        if (this.mLayout == null) {
            return Modifiers.describeFlags(this.mFlags, true);
        }
        return this.mLayout + Modifiers.describeFlags(this.mFlags, true);
    }

    public static String describeFlags(int flags) {
        return Modifiers.describeFlags(flags, false);
    }

    public static String describeFlags(int flags, boolean padded) {
        if (flags == 0) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" ", "", padded ? " " : "");
        if ((flags & 0x4000) != 0) {
            joiner.add("subroutine");
        }
        if ((flags & 0x8000) != 0) {
            joiner.add("__pure");
        }
        if ((flags & 0x10000) != 0) {
            joiner.add("inline");
        }
        if ((flags & 0x20000) != 0) {
            joiner.add("noinline");
        }
        if ((flags & 1) != 0) {
            joiner.add("smooth");
        }
        if ((flags & 2) != 0) {
            joiner.add("flat");
        }
        if ((flags & 4) != 0) {
            joiner.add("noperspective");
        }
        if ((flags & 8) != 0) {
            joiner.add("const");
        }
        if ((flags & 0x10) != 0) {
            joiner.add("uniform");
        }
        if ((flags & 0x20) != 0 && (flags & 0x40) != 0) {
            joiner.add("inout");
        } else if ((flags & 0x20) != 0) {
            joiner.add("in");
        } else if ((flags & 0x40) != 0) {
            joiner.add("out");
        }
        if ((flags & 0x80) != 0) {
            joiner.add("coherent");
        }
        if ((flags & 0x100) != 0) {
            joiner.add("volatile");
        }
        if ((flags & 0x200) != 0) {
            joiner.add("restrict");
        }
        if ((flags & 0x400) != 0) {
            joiner.add("readonly");
        }
        if ((flags & 0x800) != 0) {
            joiner.add("writeonly");
        }
        if ((flags & 0x1000) != 0) {
            joiner.add("buffer");
        }
        if ((flags & 0x2000) != 0) {
            joiner.add("workgroup");
        }
        return joiner.toString();
    }
}

