/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

public final class Layout {
    public static final int kOriginUpperLeft_LayoutFlag = 1;
    public static final int kPixelCenterInteger_LayoutFlag = 2;
    public static final int kEarlyFragmentTests_LayoutFlag = 4;
    public static final int kBlendSupportAllEquations_LayoutFlag = 8;
    public static final int kPushConstant_LayoutFlag = 16;
    public static final int kStd140_LayoutFlag = 32;
    public static final int kStd430_LayoutFlag = 64;
    public static final int kLocation_LayoutFlag = 128;
    public static final int kComponent_LayoutFlag = 256;
    public static final int kIndex_LayoutFlag = 512;
    public static final int kBinding_LayoutFlag = 1024;
    public static final int kOffset_LayoutFlag = 2048;
    public static final int kSet_LayoutFlag = 4096;
    public static final int kInputAttachmentIndex_LayoutFlag = 8192;
    public static final int kBuiltin_LayoutFlag = 16384;
    public static final int kCount_LayoutFlag = 15;
    private int mLayoutFlags = 0;
    public int mLocation = -1;
    public int mComponent = -1;
    public int mIndex = -1;
    public int mBinding = -1;
    public int mOffset = -1;
    public int mSet = -1;
    public int mInputAttachmentIndex = -1;
    public int mBuiltin = -1;

    public static String describeLayoutFlag(int flag) {
        assert (Integer.bitCount(flag) == 1);
        return switch (Integer.numberOfTrailingZeros(flag)) {
            case 0 -> "origin_upper_left";
            case 1 -> "pixel_center_integer";
            case 2 -> "early_fragment_tests";
            case 3 -> "blend_support_all_equations";
            case 4 -> "push_constant";
            case 5 -> "std140";
            case 6 -> "std430";
            case 7 -> "location";
            case 8 -> "component";
            case 9 -> "index";
            case 10 -> "binding";
            case 11 -> "offset";
            case 12 -> "set";
            case 13 -> "input_attachment_index";
            case 14 -> "builtin";
            default -> "";
        };
    }

    public int layoutFlags() {
        return this.mLayoutFlags;
    }

    public void setLayoutFlag(@Nonnull Context context, int mask, String name, int pos) {
        if ((this.mLayoutFlags & mask) != 0) {
            context.error(pos, "layout qualifier '" + name + "' appears more than once");
        }
        this.mLayoutFlags |= mask;
    }

    public void clearLayoutFlag(int mask) {
        this.mLayoutFlags &= ~mask;
    }

    public boolean checkLayoutFlags(@Nonnull Context context, int pos, int permittedLayoutFlags) {
        boolean success = true;
        for (int i = 0; i < 15; ++i) {
            int flag = 1 << i;
            if ((this.mLayoutFlags & flag) == 0 || (permittedLayoutFlags & flag) != 0) continue;
            context.error(pos, "layout qualifier '" + Layout.describeLayoutFlag(flag) + "' is not permitted here");
            success = false;
        }
        return success;
    }

    public int hashCode() {
        int result = this.mLayoutFlags;
        result = 31 * result + this.mLocation;
        result = 31 * result + this.mComponent;
        result = 31 * result + this.mIndex;
        result = 31 * result + this.mBinding;
        result = 31 * result + this.mOffset;
        result = 31 * result + this.mSet;
        result = 31 * result + this.mInputAttachmentIndex;
        result = 31 * result + this.mBuiltin;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Layout layout = (Layout)o;
        if (this.mLayoutFlags != layout.mLayoutFlags) {
            return false;
        }
        if (this.mLocation != layout.mLocation) {
            return false;
        }
        if (this.mComponent != layout.mComponent) {
            return false;
        }
        if (this.mIndex != layout.mIndex) {
            return false;
        }
        if (this.mBinding != layout.mBinding) {
            return false;
        }
        if (this.mOffset != layout.mOffset) {
            return false;
        }
        if (this.mSet != layout.mSet) {
            return false;
        }
        if (this.mInputAttachmentIndex != layout.mInputAttachmentIndex) {
            return false;
        }
        return this.mBuiltin == layout.mBuiltin;
    }

    @Nonnull
    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "layout(", ") ");
        if (this.mLocation >= 0) {
            joiner.add("location = " + this.mLocation);
        }
        if (this.mComponent >= 0) {
            joiner.add("component = " + this.mComponent);
        }
        if (this.mIndex >= 0) {
            joiner.add("index = " + this.mIndex);
        }
        if (this.mBinding >= 0) {
            joiner.add("binding = " + this.mBinding);
        }
        if (this.mOffset >= 0) {
            joiner.add("offset = " + this.mOffset);
        }
        if (this.mSet >= 0) {
            joiner.add("set = " + this.mSet);
        }
        if (this.mInputAttachmentIndex >= 0) {
            joiner.add("input_attachment_index = " + this.mInputAttachmentIndex);
        }
        if (this.mBuiltin >= 0) {
            joiner.add("builtin = " + this.mBuiltin);
        }
        if ((this.mLayoutFlags & 1) != 0) {
            joiner.add("origin_upper_left");
        }
        if ((this.mLayoutFlags & 2) != 0) {
            joiner.add("pixel_center_integer");
        }
        if ((this.mLayoutFlags & 4) != 0) {
            joiner.add("early_fragment_tests");
        }
        if ((this.mLayoutFlags & 8) != 0) {
            joiner.add("blend_support_all_equations");
        }
        if ((this.mLayoutFlags & 0x10) != 0) {
            joiner.add("push_constant");
        }
        if ((this.mLayoutFlags & 0x20) != 0) {
            joiner.add("std140");
        }
        if ((this.mLayoutFlags & 0x40) != 0) {
            joiner.add("std430");
        }
        return joiner.toString();
    }
}

