/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.ConstantFolder;
import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.analysis.Analysis;
import icyllis.arc3d.compiler.tree.ConstructorArray;
import icyllis.arc3d.compiler.tree.ConstructorCall;
import icyllis.arc3d.compiler.tree.ConstructorCompoundCast;
import icyllis.arc3d.compiler.tree.ConstructorScalarCast;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Type;
import javax.annotation.Nonnull;

public final class ConstructorArrayCast
extends ConstructorCall {
    private ConstructorArrayCast(int position, Type type, Expression ... arguments) {
        super(position, type, arguments);
        assert (arguments.length == 1);
    }

    @Nonnull
    public static Expression make(@Nonnull Context context, int position, @Nonnull Type type, @Nonnull Expression arg) {
        assert (type.isArray());
        assert (arg.getType().isArray());
        assert (type.getArraySize() == arg.getType().getArraySize());
        if (type.matches(arg.getType())) {
            arg.mPosition = position;
            return arg;
        }
        if (Analysis.isCompileTimeConstant(arg = ConstantFolder.makeConstantValueForVariable(position, arg))) {
            Type scalarType = type.getComponentType();
            Expression[] inputArgs = ((ConstructorArray)arg).getArguments();
            Expression[] typecastArgs = new Expression[inputArgs.length];
            for (int i = 0; i < inputArgs.length; ++i) {
                Expression inputArg = inputArgs[i];
                typecastArgs[i] = inputArg.getType().isScalar() ? ConstructorScalarCast.make(context, inputArg.mPosition, scalarType, inputArg) : ConstructorCompoundCast.make(inputArg.mPosition, scalarType, inputArg);
            }
            return ConstructorArray.make(position, type, typecastArgs);
        }
        return new ConstructorArrayCast(position, type, arg);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONSTRUCTOR_ARRAY_CAST;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConstructorArrayCast(position, this.getType(), this.cloneArguments());
    }
}

