/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler;

import icyllis.arc3d.compiler.tree.Type;
import icyllis.arc3d.core.MathUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MemoryLayout
extends Enum<MemoryLayout> {
    public static final /* enum */ MemoryLayout Std140 = new MemoryLayout();
    public static final /* enum */ MemoryLayout Extended = new MemoryLayout();
    public static final /* enum */ MemoryLayout Std430 = new MemoryLayout();
    public static final /* enum */ MemoryLayout Scalar = new MemoryLayout();
    private static final /* synthetic */ MemoryLayout[] $VALUES;

    public static MemoryLayout[] values() {
        return (MemoryLayout[])$VALUES.clone();
    }

    public static MemoryLayout valueOf(String name) {
        return Enum.valueOf(MemoryLayout.class, name);
    }

    public int alignment(@Nonnull Type type) {
        return this.alignment(type, null);
    }

    public int alignment(@Nonnull Type type, @Nullable int[] out) {
        return switch (type.getTypeKind()) {
            case 5 -> {
                int width = type.getWidth();
                if (width == 32) {
                    if (out != null) {
                        out[0] = 4;
                        out[2] = 0;
                        out[1] = 0;
                    }
                    yield 4;
                }
                throw new UnsupportedOperationException();
            }
            case 7 -> {
                int scalarAlign = this.alignment(type.getElementType(), out);
                if (out != null) {
                    out[0] = out[0] * type.getRows();
                }
                if (this != Scalar) {
                    yield scalarAlign << (type.getRows() > 2 ? 2 : 1);
                }
                yield scalarAlign;
            }
            case 2 -> {
                int align = this.alignment(type.getElementType(), out);
                if (this == Std140) {
                    align = Math.max(align, 16);
                    if (!$assertionsDisabled && (align & 0xF) != 0) {
                        throw new AssertionError();
                    }
                }
                if (out != null) {
                    out[1] = MathUtil.alignTo(out[0], align);
                    out[0] = out[1] * type.getCols();
                }
                yield align;
            }
            case 0 -> {
                int align = this.alignment(type.getElementType(), out);
                if (this == Std140 || this == Extended) {
                    align = Math.max(align, 16);
                    if (!$assertionsDisabled && (align & 0xF) != 0) {
                        throw new AssertionError();
                    }
                }
                if (out != null) {
                    out[2] = MathUtil.alignTo(out[0], align);
                    out[0] = type.isUnsizedArray() ? out[2] : out[2] * type.getArraySize();
                }
                yield align;
            }
            case 6 -> {
                int align = 0;
                int size = 0;
                for (Type.Field field : type.getFields()) {
                    int memberAlign = this.alignment(field.type(), out);
                    align = Math.max(align, memberAlign);
                    if (out == null) continue;
                    size = MathUtil.alignTo(size, memberAlign);
                    size += out[0];
                }
                if (this == Std140 || this == Extended) {
                    align = Math.max(align, 16);
                    if (!$assertionsDisabled && (align & 0xF) != 0) {
                        throw new AssertionError();
                    }
                }
                if (out != null) {
                    if (this != Scalar) {
                        size = MathUtil.alignTo(size, align);
                    }
                    out[0] = size;
                    out[2] = 0;
                    out[1] = 0;
                }
                yield align;
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    public int stride(@Nonnull Type type) {
        return MathUtil.alignTo(switch (type.getTypeKind()) {
            case 0, 2 -> this.size(type.getElementType());
            default -> throw new UnsupportedOperationException();
        }, this.alignment(type));
    }

    public int size(@Nonnull Type type) {
        return switch (type.getTypeKind()) {
            case 5 -> {
                int width = type.getWidth();
                if (width == 32) {
                    yield 4;
                }
                throw new UnsupportedOperationException();
            }
            case 7 -> {
                int size = this.size(type.getElementType());
                yield size * type.getRows();
            }
            case 2 -> {
                int stride = this.stride(type);
                yield stride * type.getCols();
            }
            case 0 -> {
                int stride = this.stride(type);
                if (type.isUnsizedArray()) {
                    yield stride;
                }
                yield stride * type.getArraySize();
            }
            case 6 -> {
                int size = 0;
                for (Type.Field field : type.getFields()) {
                    int memberAlign = this.alignment(field.type());
                    size = MathUtil.alignTo(size, memberAlign);
                    size += this.size(field.type());
                }
                if (this != Scalar) {
                    int align = this.alignment(type);
                    size = MathUtil.alignTo(size, align);
                }
                yield size;
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    public boolean isSupported(@Nonnull Type type) {
        return switch (type.getTypeKind()) {
            case 5 -> {
                if (!type.isBoolean()) {
                    yield true;
                }
                yield false;
            }
            case 0, 2, 7 -> this.isSupported(type.getElementType());
            case 6 -> {
                for (Type.Field field : type.getFields()) {
                    if (this.isSupported(field.type())) continue;
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }

    private static /* synthetic */ MemoryLayout[] $values() {
        return new MemoryLayout[]{Std140, Extended, Std430, Scalar};
    }

    static {
        $VALUES = MemoryLayout.$values();
    }
}

