/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.init.v3.capability;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public final class NeoForgeCapabilityHelper {
    private NeoForgeCapabilityHelper() {
    }

    @SafeVarargs
    public static void registerChestBlock(Holder<? extends ChestBlock> ... chestBlocks) {
        NeoForgeCapabilityHelper.register((registerCapabilitiesEvent, chestBlock) -> registerCapabilitiesEvent.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, side) -> {
            Container container = ChestBlock.getContainer((ChestBlock)((ChestBlock)state.getBlock()), (BlockState)state, (Level)level, (BlockPos)pos, (boolean)true);
            Objects.requireNonNull(container, "chest container is null");
            return new InvWrapper(container);
        }, new Block[]{chestBlock}), chestBlocks);
    }

    @SafeVarargs
    public static <T extends BlockEntity> void registerBlockEntityContainer(Holder<? extends BlockEntityType<? extends T>> ... blockEntityTypes) {
        NeoForgeCapabilityHelper.registerBlockEntity((blockEntity, direction) -> new InvWrapper((Container)blockEntity), blockEntityTypes);
    }

    @SafeVarargs
    public static <T extends BlockEntity> void registerWorldlyBlockEntityContainer(Holder<? extends BlockEntityType<? extends T>> ... blockEntityTypes) {
        NeoForgeCapabilityHelper.registerBlockEntity((blockEntity, direction) -> direction != null ? new SidedInvWrapper((WorldlyContainer)blockEntity, direction) : new InvWrapper((Container)blockEntity), blockEntityTypes);
    }

    @SafeVarargs
    public static <T extends BlockEntity> void registerRestrictedBlockEntityContainer(Holder<? extends BlockEntityType<? extends T>> ... blockEntityTypes) {
        NeoForgeCapabilityHelper.registerBlockEntity((blockEntity, direction) -> new SidedInvWrapper((WorldlyContainer)blockEntity, null), blockEntityTypes);
    }

    @SafeVarargs
    public static <T extends BlockEntity> void registerBlockEntity(ICapabilityProvider<T, Direction, IItemHandler> capabilityProvider, Holder<? extends BlockEntityType<? extends T>> ... blockEntityTypes) {
        NeoForgeCapabilityHelper.register((evt, blockEntityType) -> evt.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, capabilityProvider), blockEntityTypes);
    }

    @SafeVarargs
    public static <T extends Entity> void registerEntityContainer(Holder<? extends EntityType<? extends T>> ... entityTypes) {
        NeoForgeCapabilityHelper.register((evt, entityType) -> {
            evt.registerEntity(Capabilities.ItemHandler.ENTITY, entityType, (entity, aVoid) -> new InvWrapper((Container)entity));
            evt.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, entityType, (entity, direction) -> new InvWrapper((Container)entity));
        }, entityTypes);
    }

    @SafeVarargs
    public static void registerItemContainer(ICapabilityProvider<ItemStack, Void, IItemHandler> capabilityProvider, Holder<? extends Item> ... items) {
        NeoForgeCapabilityHelper.register((evt, item) -> evt.registerItem(Capabilities.ItemHandler.ITEM, capabilityProvider, new ItemLike[]{item}), items);
    }

    @SafeVarargs
    public static <T> void register(BiConsumer<RegisterCapabilitiesEvent, T> consumer, Holder<? extends T> ... types) {
        Preconditions.checkState((types.length > 0 ? 1 : 0) != 0, (Object)"capability provider types is empty");
        ResourceLocation resourceLocation = ((ResourceKey)types[0].unwrapKey().orElseThrow()).location();
        NeoForgeModContainerHelper.getOptionalModEventBus(resourceLocation.getNamespace()).ifPresent(eventBus -> eventBus.addListener(evt -> {
            for (Holder holder : types) {
                consumer.accept((RegisterCapabilitiesEvent)evt, (Object)holder.value());
            }
        }));
    }
}

