/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.gliding.util;

import com.l33tfox.gliding.items.GliderItem;
import net.minecraft.world.entity.player.Player;

public class GliderUtil {
    public static boolean isHoldingGlider(Player player) {
        return player.isHolding(itemStack -> itemStack.getItem() instanceof GliderItem);
    }

    public static boolean offHandHoldingGlider(Player player) {
        return player.getOffhandItem().getItem() instanceof GliderItem;
    }

    public static boolean mainHandHoldingGlider(Player player) {
        return player.getMainHandItem().getItem() instanceof GliderItem;
    }

    public static GliderItem getGliderItemInHand(Player player) {
        GliderItem gliderItem = null;
        if (GliderUtil.mainHandHoldingGlider(player)) {
            gliderItem = (GliderItem)player.getMainHandItem().getItem();
        } else if (GliderUtil.offHandHoldingGlider(player)) {
            gliderItem = (GliderItem)player.getOffhandItem().getItem();
        }
        return gliderItem;
    }

    public static void playerGliderMovement(Player player) {
        GliderItem gliderInHand = GliderUtil.getGliderItemInHand(player);
        double newYVelocity = gliderInHand.glideDropVelocity;
        if (player.getDeltaMovement().y > gliderInHand.glideDropVelocity) {
            newYVelocity = player.getDeltaMovement().y;
        }
        player.setDeltaMovement(player.getDeltaMovement().x * gliderInHand.glideSpeedIncreaseFactor, newYVelocity, player.getDeltaMovement().z * gliderInHand.glideSpeedIncreaseFactor);
    }

    public static void resetFallDamage(Player player) {
        player.fallDistance = 0.0f;
    }
}

