/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.gliding.util;

import com.l33tfox.gliding.PlayerEntityDuck;
import com.l33tfox.gliding.client.sound.GliderSoundManager;
import com.l33tfox.gliding.client.sound.GlidingWindSoundInstance;
import com.l33tfox.gliding.networking.payload.GliderActivatedC2SPayload;
import com.l33tfox.gliding.util.GliderUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GliderClientUtil {
    public static int ticksUsingGlider = 0;

    public static boolean isActivatingGlider(LocalPlayer player) {
        return GliderUtil.isHoldingGlider((Player)player) && player.input.jumping && !player.getAbilities().flying && !player.isSwimming() && !player.isInLiquid();
    }

    public static boolean isUsingGliderMoreThanOneJump() {
        return ticksUsingGlider > 4;
    }

    public static boolean isGliding(LocalPlayer player) {
        Vec3 velocity = player.getDeltaMovement();
        return GliderClientUtil.isActivatingGlider(player) && GliderClientUtil.isUsingGliderMoreThanOneJump() && !player.onGround() && !player.isFallFlying() && velocity.y < 0.0;
    }

    public static void glidingTick(Minecraft client) {
        LocalPlayer player = client.player;
        if (player != null && GliderClientUtil.isActivatingGlider(player)) {
            ++ticksUsingGlider;
            if (GliderClientUtil.isGliding(player)) {
                GliderUtil.playerGliderMovement((Player)player);
                GliderUtil.resetFallDamage((Player)player);
                GliderSoundManager gliderSoundManager = GliderSoundManager.getInstance();
                gliderSoundManager.play(new GlidingWindSoundInstance((Player)player, gliderSoundManager));
                ((PlayerEntityDuck)player).gliding$setIsActivatingGlider(true);
                ((PlayerEntityDuck)player).gliding$setIsGliding(true);
                ClientPlayNetworking.send((CustomPacketPayload)new GliderActivatedC2SPayload(true, true));
            } else if (GliderClientUtil.isUsingGliderMoreThanOneJump()) {
                ((PlayerEntityDuck)player).gliding$setIsActivatingGlider(true);
                ((PlayerEntityDuck)player).gliding$setIsGliding(false);
                ClientPlayNetworking.send((CustomPacketPayload)new GliderActivatedC2SPayload(true, false));
            }
        } else if (player != null && ((PlayerEntityDuck)player).gliding$isActivatingGlider()) {
            ticksUsingGlider = 0;
            ((PlayerEntityDuck)player).gliding$setIsActivatingGlider(false);
            ((PlayerEntityDuck)player).gliding$setIsGliding(false);
            ClientPlayNetworking.send((CustomPacketPayload)new GliderActivatedC2SPayload(false, false));
        }
    }
}

