/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.gliding.mixin;

import com.l33tfox.gliding.PlayerEntityDuck;
import com.l33tfox.gliding.items.GliderItem;
import com.l33tfox.gliding.util.GliderUtil;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class BipedEntityModelMixin<T extends LivingEntity> {
    private float prevLegPitch = 0.0f;
    private float prevArmPitch = 0.0f;
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart leftLeg;
    @Shadow
    @Final
    public ModelPart rightLeg;

    @Inject(at={@At(value="TAIL")}, method={"setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V"})
    private void setLimbsGliding(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        Player player;
        if (livingEntity instanceof Player && ((PlayerEntityDuck)(player = (Player)livingEntity)).gliding$isActivatingGlider()) {
            if (player.getOffhandItem().isEmpty() || player.getOffhandItem().getItem() instanceof GliderItem) {
                this.leftArm.xRot = (float)Math.PI;
                this.leftArm.zRot = 0.19634955f;
            }
            if (player.getMainHandItem().isEmpty() || player.getMainHandItem().getItem() instanceof GliderItem) {
                this.rightArm.xRot = (float)Math.PI;
                this.rightArm.zRot = -0.19634955f;
            }
            if (((PlayerEntityDuck)player).gliding$isGliding() && !player.onGround()) {
                if (this.prevLegPitch == 0.0f || (double)Math.abs(this.leftLeg.xRot) < 0.09817477042468103) {
                    this.leftLeg.xRot = 0.0f;
                    this.rightLeg.xRot = 0.0f;
                }
                if (!player.getMainHandItem().isEmpty() && !GliderUtil.mainHandHoldingGlider(player) || !player.getOffhandItem().isEmpty() && !GliderUtil.offHandHoldingGlider(player)) {
                    ModelPart armHoldingOtherItem;
                    ModelPart modelPart = armHoldingOtherItem = GliderUtil.mainHandHoldingGlider(player) ? this.leftArm : this.rightArm;
                    if ((this.prevArmPitch == -0.19634955f || (double)Math.abs(armHoldingOtherItem.xRot) < 0.19634954084936207) && !player.isUsingItem()) {
                        armHoldingOtherItem.xRot = -0.19634955f;
                    }
                    this.prevArmPitch = armHoldingOtherItem.xRot;
                }
            } else {
                this.prevArmPitch = this.leftArm.xRot;
            }
            this.prevLegPitch = this.leftLeg.xRot;
        }
    }
}

