/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.gliding.client.sound;

import com.l33tfox.gliding.PlayerEntityDuck;
import com.l33tfox.gliding.client.sound.GliderSoundManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

@Environment(value=EnvType.CLIENT)
public class GlidingWindSoundInstance
extends AbstractTickableSoundInstance {
    public Player glidingPlayer;
    private int tickCount;
    GliderSoundManager soundManager;

    public GlidingWindSoundInstance(Player player, GliderSoundManager manager) {
        super(SoundEvents.ELYTRA_FLYING, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.glidingPlayer = player;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
        this.soundManager = manager;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.glidingPlayer.isRemoved() && ((PlayerEntityDuck)this.glidingPlayer).gliding$isGliding()) {
            this.setPositionToPlayer();
            float velocitySquared = (float)this.glidingPlayer.getDeltaMovement().lengthSqr();
            this.volume = (double)velocitySquared >= 1.0E-7 ? Mth.clamp((float)(velocitySquared / 8.0f), (float)0.0f, (float)1.0f) : 0.0f;
            if (this.tickCount < 20) {
                this.volume = 0.0f;
            } else if (this.tickCount < 40) {
                this.volume *= (float)(this.tickCount - 20) / 20.0f;
            }
            this.pitch = this.volume > 0.8f ? 1.0f + (this.volume - 0.8f) : 1.0f;
        } else {
            this.stop();
            this.soundManager.onSoundFinished((SoundInstance)this);
        }
    }

    private void setPositionToPlayer() {
        this.x = this.glidingPlayer.getX();
        this.y = this.glidingPlayer.getY();
        this.z = this.glidingPlayer.getZ();
    }

    public boolean equals(Object obj) {
        return obj instanceof GlidingWindSoundInstance && ((GlidingWindSoundInstance)((Object)obj)).glidingPlayer == this.glidingPlayer;
    }
}

