/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.gliding.client.sound;

import com.l33tfox.gliding.client.sound.GlidingWindSoundInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;

public class GliderSoundManager {
    private static final Minecraft client = Minecraft.getInstance();
    private static GliderSoundManager instance;
    private final List<GlidingWindSoundInstance> activeSounds = new ArrayList<GlidingWindSoundInstance>();

    private GliderSoundManager() {
    }

    public static GliderSoundManager getInstance() {
        if (instance == null) {
            instance = new GliderSoundManager();
        }
        return instance;
    }

    public void onSoundFinished(SoundInstance sound) {
        if (sound instanceof GlidingWindSoundInstance) {
            this.stop((GlidingWindSoundInstance)sound);
        }
    }

    public <T extends GlidingWindSoundInstance> void play(T soundInstance) {
        if (this.activeSounds.contains(soundInstance)) {
            return;
        }
        client.getSoundManager().play(soundInstance);
        this.activeSounds.add(soundInstance);
    }

    public <T extends GlidingWindSoundInstance> void stop(T soundInstance) {
        client.getSoundManager().stop(soundInstance);
        this.activeSounds.remove(soundInstance);
    }

    public Optional<GlidingWindSoundInstance> getPlayingSoundInstance(SoundEvent soundEvent) {
        for (GlidingWindSoundInstance activeSound : this.activeSounds) {
            if (!activeSound.getLocation().equals((Object)soundEvent.getLocation())) continue;
            return Optional.of(activeSound);
        }
        return Optional.empty();
    }
}

