/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.gliding.client.renderer;

import com.l33tfox.gliding.GlidingClient;
import com.l33tfox.gliding.PlayerEntityDuck;
import com.l33tfox.gliding.client.GliderModel;
import com.l33tfox.gliding.util.GliderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class GliderModelFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final GliderModel gliderModel;

    public GliderModelFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context, EntityModelSet loader) {
        super(context);
        this.gliderModel = new GliderModel(loader.bakeLayer(GlidingClient.GLIDER_LAYER));
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (((PlayerEntityDuck)player).gliding$isActivatingGlider() && GliderUtil.isHoldingGlider((Player)player)) {
            String gliderID = BuiltInRegistries.ITEM.getKey((Object)GliderUtil.getGliderItemInHand((Player)player)).getPath();
            ResourceLocation gliderCutout = ResourceLocation.fromNamespaceAndPath((String)"gliding", (String)("textures/item/" + gliderID + "_model.png"));
            matrices.pushPose();
            this.gliderModel.setupAnim((Entity)player, limbAngle, limbDistance, tickDelta, headYaw, headPitch);
            matrices.translate(0.0, -1.75, 0.0);
            VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)gliderCutout), (boolean)true, (boolean)false);
            this.gliderModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
    }
}

