/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.registry;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import plus.dragons.visuality.particle.ChargeParticle;
import plus.dragons.visuality.particle.FeatherParticle;
import plus.dragons.visuality.particle.SlimeParticle;
import plus.dragons.visuality.particle.SolidFallingParticle;
import plus.dragons.visuality.particle.SoulParticle;
import plus.dragons.visuality.particle.SparkleParticle;
import plus.dragons.visuality.particle.VisualityParticleEngine;
import plus.dragons.visuality.particle.WaterCircleParticle;
import plus.dragons.visuality.particle.type.ColorParticleType;
import plus.dragons.visuality.particle.type.ColorScaleParticleType;
import plus.dragons.visuality.registry.VisualityRegistries;

public class VisualityParticles {
    public static final DeferredHolder<ParticleType<?>, ColorParticleType> SPARKLE = VisualityParticles.register("sparkle", ColorParticleType::new);
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> BONE = VisualityParticles.register("bone");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> WITHER_BONE = VisualityParticles.register("wither_bone");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> FEATHER = VisualityParticles.register("feather");
    public static final DeferredHolder<ParticleType<?>, ColorScaleParticleType> SMALL_SLIME_BLOB = VisualityParticles.register("small_slime_blob", ColorScaleParticleType::new);
    public static final DeferredHolder<ParticleType<?>, ColorScaleParticleType> MEDIUM_SLIME_BLOB = VisualityParticles.register("medium_slime_blob", ColorScaleParticleType::new);
    public static final DeferredHolder<ParticleType<?>, ColorScaleParticleType> BIG_SLIME_BLOB = VisualityParticles.register("big_slime_blob", ColorScaleParticleType::new);
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> CHARGE = VisualityParticles.register("charge");
    public static final DeferredHolder<ParticleType<?>, ColorParticleType> WATER_CIRCLE = VisualityParticles.register("water_circle", ColorParticleType::new);
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> EMERALD = VisualityParticles.register("emerald");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> SOUL = VisualityParticles.register("soul");

    private static DeferredHolder<ParticleType<?>, SimpleParticleType> register(String name) {
        return VisualityRegistries.PARTICLE_TYPES.register(name, () -> new SimpleParticleType(false));
    }

    private static <O extends ParticleOptions, T extends ParticleType<O>> DeferredHolder<ParticleType<?>, T> register(String name, Supplier<T> factory) {
        return VisualityRegistries.PARTICLE_TYPES.register(name, factory);
    }

    public static void register() {
    }

    public static void registerProviders(RegisterParticleProvidersEvent event) {
        VisualityParticleEngine engine = (VisualityParticleEngine)Minecraft.getInstance().particleEngine;
        engine.registerVisuality(SPARKLE, SparkleParticle.Provider::new);
        engine.registerVisuality(BONE, SolidFallingParticle.Provider::new);
        engine.registerVisuality(WITHER_BONE, SolidFallingParticle.Provider::new);
        engine.registerVisuality(FEATHER, FeatherParticle.Provider::new);
        engine.registerVisuality(SMALL_SLIME_BLOB, SlimeParticle.Provider::new);
        engine.registerVisuality(MEDIUM_SLIME_BLOB, SlimeParticle.Provider::new);
        engine.registerVisuality(BIG_SLIME_BLOB, SlimeParticle.Provider::new);
        engine.registerVisuality(CHARGE, ChargeParticle.Provider::new);
        engine.registerVisuality(WATER_CIRCLE, WaterCircleParticle.Provider::new);
        engine.registerVisuality(EMERALD, SolidFallingParticle.Provider::new);
        engine.registerVisuality(SOUL, SoulParticle.Provider::new);
    }
}

