/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class ColorParticleType
extends ParticleType<Options> {
    private final MapCodec<Options> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VECTOR3F.fieldOf("color").forGetter(Options::color)).apply((Applicative)instance, x$0 -> new Options((Vector3f)x$0)));
    private final StreamCodec<? super RegistryFriendlyByteBuf, Options> streamCodec = StreamCodec.ofMember(Options::encode, x$0 -> new Options((FriendlyByteBuf)x$0));

    public ColorParticleType(boolean overrideLimiter) {
        super(overrideLimiter);
    }

    public MapCodec<Options> codec() {
        return this.codec;
    }

    public ColorParticleType() {
        this(false);
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, Options> streamCodec() {
        return this.streamCodec;
    }

    public Options withColor(float r, float g, float b) {
        return new Options(r, g, b);
    }

    public Options withColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Options(r, g, b);
    }

    public class Options
    implements ParticleOptions {
        public final float r;
        public final float g;
        public final float b;

        private Options(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        private Options(Vector3f vec) {
            this(vec.x(), vec.y(), vec.z());
        }

        private Options(FriendlyByteBuf buffer) {
            this.r = buffer.readFloat();
            this.g = buffer.readFloat();
            this.b = buffer.readFloat();
        }

        public ParticleType<?> getType() {
            return ColorParticleType.this;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
        }

        public Vector3f color() {
            return new Vector3f(this.r, this.g, this.b);
        }
    }
}

