/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import plus.dragons.visuality.config.BlockAmbientParticleConfig;
import plus.dragons.visuality.config.BlockStepParticleConfig;
import plus.dragons.visuality.config.EntityArmorParticleConfig;
import plus.dragons.visuality.config.EntityHitParticleConfig;

public class Config {
    public static EntityHitParticleConfig ENTITY_HIT_PARTICLES;
    public static EntityArmorParticleConfig ENTITY_ARMOR_PARTICLES;
    public static BlockAmbientParticleConfig BLOCK_AMBIENT_PARTICLES;
    public static BlockStepParticleConfig BLOCK_STEP_PARTICLES;
    public static final ModConfigSpec.BooleanValue SLIME_ENABLED;
    public static final ModConfigSpec.BooleanValue CHARGE_ENABLED;
    public static final ModConfigSpec.BooleanValue WATER_CIRCLE_ENABLED;
    public static final ModConfigSpec.BooleanValue WATER_CIRCLE_COLORED;
    public static final ModConfigSpec.IntValue WATER_CIRCLE_DENSITY;
    public static final ModConfigSpec SPEC;

    public static void registerClientResourceListener(RegisterClientReloadListenersEvent event) {
        ENTITY_HIT_PARTICLES = new EntityHitParticleConfig();
        event.registerReloadListener((PreparableReloadListener)ENTITY_HIT_PARTICLES);
        ENTITY_ARMOR_PARTICLES = new EntityArmorParticleConfig();
        event.registerReloadListener((PreparableReloadListener)ENTITY_ARMOR_PARTICLES);
        BLOCK_AMBIENT_PARTICLES = new BlockAmbientParticleConfig();
        event.registerReloadListener((PreparableReloadListener)BLOCK_AMBIENT_PARTICLES);
        BLOCK_STEP_PARTICLES = new BlockStepParticleConfig();
        event.registerReloadListener((PreparableReloadListener)BLOCK_STEP_PARTICLES);
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("slime");
        SLIME_ENABLED = builder.translation("config.visuality.option.slime").comment("Slime Blobs Enabled").define("enabled", true);
        builder.pop();
        builder.push("charge");
        CHARGE_ENABLED = builder.translation("config.visuality.option.charge").comment("Charge Particle Enabled").define("enabled", true);
        builder.pop();
        builder.push("waterCircle");
        WATER_CIRCLE_ENABLED = builder.translation("config.visuality.option.waterCircle").comment("Water Circles Enabled").define("enabled", true);
        WATER_CIRCLE_COLORED = builder.translation("config.visuality.option.waterCircle.colored").comment("Water Circles Colored").define("colored", true);
        WATER_CIRCLE_DENSITY = builder.translation("config.visuality.option.waterCircle.density").comment("Water Circles Density").defineInRange("density", 16, 0, 64);
        builder.pop();
        SPEC = builder.build();
    }
}

