/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.betterx.bclib.util.MHelper;

public class StructureHelper {
    public static class_3499 readStructure(class_2960 resource) {
        String ns = resource.method_12836();
        String nm = resource.method_12832();
        return StructureHelper.readStructure("/data/" + ns + "/structure/" + nm + ".nbt");
    }

    public static class_3499 readStructure(File datapack, String path) {
        if (datapack.isDirectory()) {
            return StructureHelper.readStructure(String.valueOf(datapack) + "/" + path);
        }
        if (datapack.isFile() && datapack.getName().endsWith(".zip")) {
            try {
                ZipFile zipFile = new ZipFile(datapack);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    long compressedSize = entry.getCompressedSize();
                    long normalSize = entry.getSize();
                    String type = entry.isDirectory() ? "DIR" : "FILE";
                    System.out.println(name);
                    System.out.format("\t %s - %d - %d\n", type, compressedSize, normalSize);
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class_3499 readStructure(String path) {
        try {
            InputStream inputstream = StructureHelper.class.getResourceAsStream(path);
            return StructureHelper.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class_3499 readStructureFromStream(InputStream stream) throws IOException {
        class_2487 nbttagcompound = class_2507.method_10629((InputStream)stream, (class_2505)class_2505.method_53898());
        class_3499 template = new class_3499();
        template.method_15183((class_7871)class_7923.field_41175.method_46771(), nbttagcompound);
        return template;
    }

    public static class_2338 offsetPos(class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror) {
        class_243 offset = class_3499.method_15176((class_243)class_243.method_24953((class_2382)structure.method_15160()), (class_2415)mirror, (class_2470)rotation, (class_2338)class_2338.field_10980);
        return pos.method_10069((int)(-offset.field_1352 * 0.5), 0, (int)(-offset.field_1350 * 0.5));
    }

    public static void placeCenteredBottom(class_5281 world, class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror, class_5819 random) {
        StructureHelper.placeCenteredBottom(world, pos, structure, rotation, mirror, StructureHelper.makeBox(pos), random);
    }

    public static void placeCenteredBottom(class_5281 world, class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror, class_3341 bounds, class_5819 random) {
        class_2338 offset = StructureHelper.offsetPos(pos, structure, rotation, mirror);
        class_3492 placementData = new class_3492().method_15123(rotation).method_15125(mirror).method_15126(bounds);
        structure.method_15172((class_5425)world, offset, offset, placementData, random, 4);
    }

    private static class_3341 makeBox(class_2338 pos) {
        int sx = (pos.method_10263() >> 4 << 4) - 16;
        int sz = (pos.method_10260() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return class_3341.method_34390((class_2382)new class_2382(sx, 0, sz), (class_2382)new class_2382(ex, 255, ez));
    }

    public static class_3341 getStructureBounds(class_2338 pos, class_3499 structure, class_2470 rotation, class_2415 mirror) {
        class_2382 max = structure.method_15160();
        class_243 min = class_3499.method_15176((class_243)class_243.method_24953((class_2382)structure.method_15160()), (class_2415)mirror, (class_2470)rotation, (class_2338)class_2338.field_10980);
        max = max.method_34592((int)(-min.field_1352), (int)(-min.field_1351), (int)(-min.field_1350));
        return class_3341.method_34390((class_2382)pos.method_10069((int)min.field_1352, (int)min.field_1351, (int)min.field_1350), (class_2382)max.method_35853((class_2382)pos));
    }

    public static class_3341 intersectBoxes(class_3341 box1, class_3341 box2) {
        int x1 = MHelper.max(box1.method_35415(), box2.method_35415());
        int y1 = MHelper.max(box1.method_35416(), box2.method_35416());
        int z1 = MHelper.max(box1.method_35417(), box2.method_35417());
        int x2 = MHelper.min(box1.method_35418(), box2.method_35418());
        int y2 = MHelper.min(box1.method_35419(), box2.method_35419());
        int z2 = MHelper.min(box1.method_35420(), box2.method_35420());
        return class_3341.method_34390((class_2382)new class_2382(x1, y1, z1), (class_2382)new class_2382(x2, y2, z2));
    }
}

