/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_39;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_79;
import net.minecraft.class_8567;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.LootPoolAccessor;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.interfaces.tools.AddMineableShovel;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.betterx.wover.tag.api.predefined.ToolTags;

public class LootUtil {
    public static Optional<List<class_1799>> getDrops(class_4970 block, class_2680 state, class_8567.class_8568 builder) {
        class_5321 tableID = block.method_26162();
        if (tableID == class_39.field_844) {
            return Optional.empty();
        }
        class_8567 ctx = builder.method_51874(class_181.field_1224, (Object)state).method_51875(class_173.field_1172);
        class_3218 level = ctx.method_51863();
        class_52 table = level.method_8503().method_58576().method_58295(tableID);
        if (table == class_52.field_948) {
            return Optional.empty();
        }
        return Optional.of(table.method_51878(ctx));
    }

    public static boolean addToPool(class_52.class_53 table, int index, ArrayList<class_79> newEntries) {
        List<Object> pools = new ArrayList<class_55>(0);
        try {
            for (Field f : table.getClass().getDeclaredFields()) {
                Object first;
                if (!List.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                List list = (List)f.get(table);
                if (list == null || list.size() <= 0 || (first = list.get(0)) == null || !class_55.class.isAssignableFrom(first.getClass())) continue;
                pools = list;
                break;
            }
            if (pools != null && pools.size() > index) {
                class_55 pool = (class_55)pools.get(index);
                LootPoolAccessor acc = (LootPoolAccessor)pool;
                pools.set(index, acc.bcl_mergeEntries(newEntries));
                return true;
            }
        }
        catch (Throwable t) {
            BCLib.LOGGER.error("ERROR building loot table: " + t.getMessage());
        }
        return false;
    }

    public static boolean isCorrectTool(class_1935 block, class_2680 state, class_1799 tool) {
        if (tool == null) {
            return false;
        }
        if (state != null && tool.method_7951(state)) {
            return true;
        }
        if (block instanceof AddMineableAxe && (tool.method_31573(class_3489.field_42612) || tool.method_31573(ToolTags.FABRIC_AXES))) {
            return true;
        }
        if (block instanceof AddMineablePickaxe && (tool.method_31573(class_3489.field_42614) || tool.method_31573(ToolTags.FABRIC_PICKAXES))) {
            return true;
        }
        if (block instanceof AddMineableHoe && (tool.method_31573(class_3489.field_42613) || tool.method_31573(ToolTags.FABRIC_HOES))) {
            return true;
        }
        if (block instanceof AddMineableShovel && (tool.method_31573(class_3489.field_42615) || tool.method_31573(ToolTags.FABRIC_SHOVELS))) {
            return true;
        }
        if (block instanceof AddMineableSword && (tool.method_31573(class_3489.field_42611) || tool.method_31573(ToolTags.FABRIC_SWORDS))) {
            return true;
        }
        if (block instanceof AddMineableShears && BaseShearsItem.isShear(tool)) {
            return true;
        }
        return block instanceof AddMineableHammer && tool.method_31573(CommonItemTags.HAMMERS);
    }
}

