/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AnvilRecipeInput;
import org.betterx.bclib.recipes.BCLBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.wover.item.api.ItemStackHelper;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.api.BaseUnlockableRecipeBuilder;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.TagManager;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.jetbrains.annotations.NotNull;

public class AnvilRecipe
implements class_1860<AnvilRecipeInput>,
UnknownReceipBookCategory {
    public static final String GROUP = "smithing";
    public static final class_3956<AnvilRecipe> TYPE = BCLRecipeManager.registerType(BCLib.MOD_ID, "smithing");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer(BCLib.MOD_ID, "smithing", new Serializer());
    public static final class_2960 ID = BCLib.makeID("smithing");
    private final class_1856 input;
    private final class_1799 output;
    private final int damage;
    private final class_6862<class_1792> allowedTools;
    private final int anvilLevel;
    private final int inputCount;

    public static void register() {
    }

    public AnvilRecipe(class_1856 input, class_1799 output, int inputCount, class_6862<class_1792> allowedTools, int anvilLevel, int damage) {
        this.input = input;
        this.output = ItemStackHelper.callItemStackSetupIfPossible((class_1799)output);
        this.allowedTools = allowedTools;
        this.anvilLevel = anvilLevel;
        this.inputCount = inputCount;
        this.damage = damage;
    }

    static Builder create(class_2960 id, class_1935 output) {
        return new BuilderImpl(id, output);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.output;
    }

    public boolean matches(AnvilRecipeInput craftingInventory, class_1937 level) {
        return this.matches(craftingInventory);
    }

    public class_1799 assemble(AnvilRecipeInput recipeInput, class_7225.class_7874 provider) {
        return this.output.method_7972();
    }

    public static Iterable<class_6880<class_1792>> getAllHammers() {
        class_2378 registry = WorldState.allStageRegistryAccess().method_30530(CommonItemTags.HAMMERS.comp_326());
        return registry.method_40286(CommonItemTags.HAMMERS);
    }

    public static int getHammerSlot(class_1263 c) {
        class_1799 h = c.method_5438(0);
        if (!h.method_7960() && h.method_31573(CommonItemTags.HAMMERS)) {
            return 0;
        }
        return 1;
    }

    public static int getIngredientSlot(class_1263 c) {
        return Math.abs(AnvilRecipe.getHammerSlot(c) - 1);
    }

    public class_1799 getHammer(AnvilRecipeInput c) {
        return c.hasHammer() ? c.getHammer() : null;
    }

    public class_1799 getIngredient(AnvilRecipeInput c) {
        return c.hasIngerdient() ? c.getIngredient() : null;
    }

    public class_1799 craft(AnvilRecipeInput craftingInventory, class_1657 player) {
        if (!player.method_7337()) {
            if (!this.checkHammerDurability(craftingInventory, player)) {
                return class_1799.field_8037;
            }
            class_1799 hammer = this.getHammer(craftingInventory);
            if (hammer != null) {
                hammer.method_7970(this.damage, (class_1309)player, class_1304.field_6171);
                return class_1799.field_8037;
            }
        }
        return this.assemble(craftingInventory, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
    }

    public boolean checkHammerDurability(AnvilRecipeInput craftingInventory, class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        class_1799 hammer = this.getHammer(craftingInventory);
        if (hammer != null) {
            int damage = hammer.method_7919() + this.damage;
            return damage < hammer.method_7936();
        }
        return true;
    }

    public boolean matches(AnvilRecipeInput craftingInventory) {
        class_1799 hammer = this.getHammer(craftingInventory);
        if (hammer == null) {
            return false;
        }
        class_1799 material = this.getIngredient(craftingInventory);
        if (material == null) {
            return false;
        }
        int materialCount = material.method_7947();
        return this.input.method_8093(this.getIngredient(craftingInventory)) && materialCount >= this.inputCount && hammer.method_31573(this.allowedTools);
    }

    public int getDamage() {
        return this.damage;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public class_6862<class_1792> getAllowedTools() {
        return this.allowedTools;
    }

    public class_1856 getMainIngredient() {
        return this.input;
    }

    public int getAnvilLevel() {
        return this.anvilLevel;
    }

    public boolean canUse(class_1792 tool) {
        if (tool instanceof class_1831) {
            class_1831 ti = (class_1831)tool;
            return ti.method_40131().method_40220(this.allowedTools);
        }
        return false;
    }

    public static boolean isHammer(class_1792 tool) {
        if (tool == null) {
            return false;
        }
        return tool.method_7854().method_31573(CommonItemTags.HAMMERS);
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)class_1856.method_26964(class_7923.field_41178.method_10220().filter(AnvilRecipe::isHammer).filter(this::canUse).map(class_1799::new)));
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnvilRecipe that = (AnvilRecipe)o;
        return this.damage == that.damage && (this.allowedTools != null && this.allowedTools.equals(that.allowedTools) || this.allowedTools == null && that.allowedTools == null) && this.input.equals((Object)that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.damage, this.allowedTools);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AnvilRecipe{");
        sb.append("input=").append(this.input);
        sb.append(", output=").append(this.output);
        sb.append(", damage=").append(this.damage);
        sb.append(", allowedTools=").append(this.allowedTools);
        sb.append(", anvilLevel=").append(this.anvilLevel);
        sb.append(", inputCount=").append(this.inputCount);
        sb.append('}');
        return sb.toString();
    }

    public static class BuilderImpl
    extends BCLBaseRecipeBuilder<Builder, AnvilRecipe>
    implements Builder {
        private class_6862<class_1792> allowedTools = null;
        private int anvilLevel = 1;
        private int damage = 1;
        private int inputCount = 1;

        protected BuilderImpl(class_2960 id, class_1935 output) {
            super(id, output, false);
        }

        @Override
        public Builder setInputCount(int ct) {
            this.inputCount = ct;
            return this;
        }

        @Override
        public Builder setAllowedTools(class_6862<class_1792> items) {
            this.allowedTools = items;
            return this;
        }

        @Override
        public Builder setAnvilLevel(int level) {
            this.anvilLevel = level;
            return this;
        }

        @Override
        public Builder setDamage(int damage) {
            this.damage = damage;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.inputCount <= 0) {
                this.throwIllegalStateException("Number of input items for Recipe must be positive. Recipe {} will be ignored!");
            }
        }

        @Override
        protected AnvilRecipe createRecipe(class_2960 id) {
            return new AnvilRecipe(this.primaryInput, this.output, this.inputCount, this.allowedTools, this.anvilLevel, this.damage);
        }
    }

    public static class Serializer
    implements class_1865<AnvilRecipe> {
        public static MapCodec<AnvilRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46096.fieldOf("input").forGetter(recipe -> recipe.input), (App)ItemUtil.CODEC_ITEM_STACK_WITH_NBT.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("inputCount", (Object)1).forGetter(recipe -> recipe.inputCount), (App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("allowedTools", null).forGetter(recipe -> recipe.allowedTools), (App)Codec.INT.optionalFieldOf("anvilLevel", (Object)1).forGetter(recipe -> recipe.anvilLevel), (App)Codec.INT.optionalFieldOf("damage", (Object)1).forGetter(recipe -> recipe.damage)).apply((Applicative)instance, AnvilRecipe::new));
        public static final class_9139<class_9129, AnvilRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);
        public static final class_9139<class_9129, class_6862<class_1792>> ITEM_TAG_STREAM_CODEC = TagManager.streamCodec((class_5321)class_7924.field_41197);

        public MapCodec<AnvilRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, AnvilRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static AnvilRecipe fromNetwork(class_9129 packetBuffer) {
            class_1856 input = (class_1856)class_1856.field_48355.decode((Object)packetBuffer);
            class_1799 output = (class_1799)class_1799.field_48349.decode((Object)packetBuffer);
            int inputCount = packetBuffer.method_10816();
            class_6862 allowedTools = (class_6862)ITEM_TAG_STREAM_CODEC.decode((Object)packetBuffer);
            int anvilLevel = packetBuffer.method_10816();
            int damage = packetBuffer.method_10816();
            return new AnvilRecipe(input, output, inputCount, (class_6862<class_1792>)allowedTools, anvilLevel, damage);
        }

        public static void toNetwork(class_9129 packetBuffer, AnvilRecipe recipe) {
            class_1856.field_48355.encode((Object)packetBuffer, (Object)recipe.input);
            class_1799.field_48349.encode((Object)packetBuffer, (Object)recipe.output);
            packetBuffer.method_10804(recipe.inputCount);
            ITEM_TAG_STREAM_CODEC.encode((Object)packetBuffer, recipe.allowedTools);
            packetBuffer.method_10804(recipe.anvilLevel);
            packetBuffer.method_10804(recipe.damage);
        }
    }

    public static interface Builder
    extends BaseRecipeBuilder<Builder>,
    BaseUnlockableRecipeBuilder<Builder> {
        public Builder setInputCount(int var1);

        public Builder setAllowedTools(class_6862<class_1792> var1);

        public Builder setAnvilLevel(int var1);

        public Builder setDamage(int var1);

        public Builder setPrimaryInput(class_1935 ... var1);

        public Builder setPrimaryInput(class_6862<class_1792> var1);

        public Builder setPrimaryInputAndUnlock(class_6862<class_1792> var1);

        public Builder setPrimaryInputAndUnlock(class_1935 ... var1);
    }
}

