/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.boat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1690;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4595;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_7752;
import net.minecraft.class_7753;
import net.minecraft.class_7754;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.items.boat.BaseBoatItem;
import org.betterx.wover.core.api.ModCore;

public final class BoatTypeOverride {
    private static final String DEFAULT_LAYER = "main";
    private static final List<BoatTypeOverride> values = new ArrayList<BoatTypeOverride>(8);
    private final String name;
    private final class_2248 planks;
    private final int ordinal;
    public final class_2960 id;
    public final class_2960 boatTexture;
    public final class_2960 chestBoatTexture;
    public final class_5601 boatModelName;
    public final class_5601 chestBoatModelName;
    @Environment(value=EnvType.CLIENT)
    private class_4595<class_1690> boatModel;
    @Environment(value=EnvType.CLIENT)
    private class_4595<class_1690> chestBoatModel;
    private class_1749 boat;
    private class_1749 chestBoat;
    public final boolean isRaft;

    BoatTypeOverride(ModCore modCore, String name, class_2248 planks) {
        this(modCore, name, planks, false);
    }

    BoatTypeOverride(ModCore modCore, String name, class_2248 planks, boolean isRaft) {
        this.id = modCore.mk(name);
        this.name = name;
        this.planks = planks;
        int nr = Objects.hash(name);
        if (nr >= 0 && nr <= 1000) {
            nr += 1000;
        }
        while (BoatTypeOverride.byId(nr) != null) {
            BCLib.LOGGER.warn("Boat Type Ordinal " + nr + " is already used, searching for another one");
            if (++nr < 0 || nr > 1000) continue;
            nr += 1000;
        }
        this.ordinal = nr;
        this.isRaft = isRaft;
        if (BCLib.isClient()) {
            this.boatModelName = BoatTypeOverride.createBoatModelName(this.id.method_12836(), this.id.method_12832());
            this.chestBoatModelName = BoatTypeOverride.createChestBoatModelName(this.id.method_12836(), this.id.method_12832());
            this.boatTexture = BoatTypeOverride.getTextureLocation(modCore.namespace, name, false);
            this.chestBoatTexture = BoatTypeOverride.getTextureLocation(modCore.namespace, name, true);
        } else {
            this.boatModelName = null;
            this.chestBoatModelName = null;
            this.boatTexture = null;
            this.chestBoatTexture = null;
        }
        values.add(this);
    }

    @Environment(value=EnvType.CLIENT)
    public class_4595<class_1690> getBoatModel(boolean chest) {
        return chest ? this.chestBoatModel : this.boatModel;
    }

    @Environment(value=EnvType.CLIENT)
    public void createBoatModels(class_5617.class_5618 context) {
        if (BCLib.isClient() && this.boatModel == null) {
            if (this.isRaft) {
                this.boatModel = new class_7754(context.method_32167(this.boatModelName));
                this.chestBoatModel = new class_7753(context.method_32167(this.chestBoatModelName));
            } else {
                this.boatModel = new class_554(context.method_32167(this.boatModelName));
                this.chestBoatModel = new class_7752(context.method_32167(this.chestBoatModelName));
            }
        }
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public void setBoatItem(class_1749 item) {
        this.boat = item;
    }

    public class_1749 getBoatItem() {
        return this.boat;
    }

    public void setChestBoatItem(class_1749 item) {
        this.chestBoat = item;
    }

    public class_1749 getChestBoatItem() {
        return this.chestBoat;
    }

    public static Stream<BoatTypeOverride> values() {
        return values.stream();
    }

    private static class_5601 createBoatModelName(String modID, String name) {
        return new class_5601(class_2960.method_60655((String)modID, (String)("boat/" + name)), DEFAULT_LAYER);
    }

    private static class_5601 createChestBoatModelName(String modID, String name) {
        return new class_5601(class_2960.method_60655((String)modID, (String)("chest_boat/" + name)), DEFAULT_LAYER);
    }

    private static class_2960 getTextureLocation(String modID, String name, boolean chest) {
        if (chest) {
            return class_2960.method_60655((String)modID, (String)("textures/entity/chest_boat/" + name + ".png"));
        }
        return class_2960.method_60655((String)modID, (String)("textures/entity/boat/" + name + ".png"));
    }

    public static BoatTypeOverride create(ModCore modCore, String name, class_2248 planks) {
        return BoatTypeOverride.create(modCore, name, planks, false);
    }

    public static BoatTypeOverride create(ModCore modCore, String name, class_2248 planks, boolean isRaft) {
        BoatTypeOverride t = new BoatTypeOverride(modCore, name, planks, isRaft);
        return t;
    }

    public class_1749 createItem(boolean hasChest) {
        return this.createItem(hasChest, new class_1792.class_1793().method_7889(1));
    }

    public class_1749 createItem(boolean hasChest, class_1792.class_1793 itemSettings) {
        BaseBoatItem item = new BaseBoatItem(hasChest, this, itemSettings);
        if (hasChest) {
            this.setChestBoatItem(item);
        } else {
            this.setBoatItem(item);
        }
        return item;
    }

    public static BoatTypeOverride byId(int i) {
        for (BoatTypeOverride t : values) {
            if (t.ordinal != i) continue;
            return t;
        }
        return null;
    }

    public static BoatTypeOverride byName(String string) {
        for (BoatTypeOverride t : values) {
            if (!t.name().equals(string)) continue;
            return t;
        }
        return null;
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BoatTypeOverride that = (BoatTypeOverride)obj;
        return Objects.equals(this.name, that.name) && this.ordinal == that.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinal);
    }

    public String toString() {
        return "BoatTypeOverride[name=" + this.name + ", ordinal=" + this.ordinal + "]";
    }
}

