/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function15;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.block.api.BlockProperties;

public abstract class ScatterFeatureConfig
implements class_3037 {
    public final class_4651 clusterBlock;
    public final class_4651 tipBlock;
    public final class_4651 bottomBlock;
    public final Optional<class_2680> baseState;
    public final float baseReplaceChance;
    public final float chanceOfDirectionalSpread;
    public final float chanceOfSpreadRadius2;
    public final float chanceOfSpreadRadius3;
    public final int minHeight;
    public final int maxHeight;
    public final float maxSpread;
    public final float sizeVariation;
    public final float floorChance;
    public final class_6017 spreadCount;
    public final boolean growWhileFree;

    public ScatterFeatureConfig(class_4651 clusterBlock, Optional<class_4651> tipBlock, Optional<class_4651> bottomBlock, Optional<class_2680> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, class_6017 spreadCount) {
        this.clusterBlock = clusterBlock;
        this.tipBlock = tipBlock.orElse(clusterBlock);
        this.bottomBlock = bottomBlock.orElse(clusterBlock);
        this.baseState = baseState;
        this.baseReplaceChance = baseReplaceChance;
        this.chanceOfDirectionalSpread = chanceOfDirectionalSpread;
        this.chanceOfSpreadRadius2 = chanceOfSpreadRadius2;
        this.chanceOfSpreadRadius3 = chanceOfSpreadRadius3;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.maxSpread = maxSpread;
        this.sizeVariation = sizeVariation;
        this.floorChance = floorChance;
        this.growWhileFree = growWhileFree;
        this.spreadCount = spreadCount;
    }

    public boolean isFloor(class_5819 random) {
        return random.method_43057() < this.floorChance;
    }

    public abstract boolean isValidBase(class_2680 var1);

    public abstract class_2680 createBlock(int var1, int var2, class_5819 var3, class_2338 var4);

    public static <T extends ScatterFeatureConfig> Codec<T> buildCodec(Instancer<T> instancer) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("cluster_block").forGetter(cfg -> cfg.clusterBlock), (App)class_4651.field_24937.optionalFieldOf("tip_block").orElse(Optional.empty()).forGetter(cfg -> cfg.tipBlock == cfg.clusterBlock ? Optional.empty() : Optional.of(cfg.tipBlock)), (App)class_4651.field_24937.optionalFieldOf("bottom_block").orElse(Optional.empty()).forGetter(cfg -> cfg.bottomBlock == cfg.clusterBlock ? Optional.empty() : Optional.of(cfg.bottomBlock)), (App)class_2680.field_24734.optionalFieldOf("base_state").forGetter(cfg -> cfg.baseState), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("baseReplaceChance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.baseReplaceChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_directional_spread").orElse((Object)Float.valueOf(0.7f)).forGetter(cfg -> Float.valueOf(cfg.chanceOfDirectionalSpread)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spread_radius2").orElse((Object)Float.valueOf(0.5f)).forGetter(cfg -> Float.valueOf(cfg.chanceOfSpreadRadius2)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spread_radius3").orElse((Object)Float.valueOf(0.5f)).forGetter(cfg -> Float.valueOf(cfg.chanceOfSpreadRadius3)), (App)Codec.intRange((int)1, (int)64).fieldOf("min_height").orElse((Object)2).forGetter(cfg -> cfg.minHeight), (App)Codec.intRange((int)1, (int)64).fieldOf("max_height").orElse((Object)7).forGetter(cfg -> cfg.maxHeight), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("max_spread").orElse((Object)Float.valueOf(2.0f)).forGetter(cfg -> Float.valueOf(cfg.maxSpread)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("size_variation").orElse((Object)Float.valueOf(0.7f)).forGetter(cfg -> Float.valueOf(cfg.sizeVariation)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("floor_chance").orElse((Object)Float.valueOf(0.5f)).forGetter(cfg -> Float.valueOf(cfg.floorChance)), (App)Codec.BOOL.fieldOf("grow_while_empty").orElse((Object)false).forGetter(cfg -> cfg.growWhileFree), (App)class_6017.method_35004((int)0, (int)64).fieldOf("length").orElse((Object)class_6019.method_35017((int)0, (int)3)).forGetter(cfg -> cfg.spreadCount)).apply((Applicative)instance, (Function15)instancer));
    }

    public static Builder<OnSolid> startOnSolid() {
        return Builder.start(OnSolid::new);
    }

    public static Builder<ExtendTop> startExtendTop() {
        return Builder.start(ExtendTop::new);
    }

    public static Builder<ExtendBottom> startExtendBottom() {
        return Builder.start(ExtendBottom::new);
    }

    public static interface Instancer<T extends ScatterFeatureConfig>
    extends Function15<class_4651, Optional<class_4651>, Optional<class_4651>, Optional<class_2680>, Float, Float, Float, Float, Integer, Integer, Float, Float, Float, Boolean, class_6017, T> {
    }

    public static class Builder<T extends ScatterFeatureConfig> {
        private class_4651 clusterBlock;
        private class_4651 tipBlock;
        private class_4651 bottomBlock;
        private Optional<class_2680> baseState = Optional.empty();
        private float baseReplaceChance = 0.0f;
        private float chanceOfDirectionalSpread = 0.0f;
        private float chanceOfSpreadRadius2 = 0.0f;
        private float chanceOfSpreadRadius3 = 0.0f;
        private int minHeight = 2;
        private int maxHeight = 12;
        private float maxSpread = 0.0f;
        private float sizeVariation = 0.0f;
        private float floorChance = 0.5f;
        private boolean growWhileFree = false;
        public class_6017 spreadCount = class_6016.method_34998((int)0);
        private final Instancer<T> instancer;

        public Builder(Instancer<T> instancer) {
            this.instancer = instancer;
        }

        public static <T extends ScatterFeatureConfig> Builder<T> start(Instancer<T> instancer) {
            return new Builder<T>(instancer);
        }

        public Builder<T> block(class_2248 b) {
            return this.block(b.method_9564());
        }

        public Builder<T> singleBlock(class_2248 b) {
            return this.block(b.method_9564()).heightRange(1, 1).spread(0.0f, 0.0f, (class_6017)class_6016.method_34998((int)0));
        }

        public Builder<T> block(class_2680 s) {
            this.clusterBlock = class_4651.method_38433((class_2680)s);
            if (this.tipBlock == null) {
                this.tipBlock = class_4651.method_38433((class_2680)s);
            }
            if (this.bottomBlock == null) {
                this.bottomBlock = class_4651.method_38433((class_2680)s);
            }
            return this;
        }

        public Builder<T> tipBlock(class_2680 s) {
            this.tipBlock = class_4651.method_38433((class_2680)s);
            return this;
        }

        public Builder<T> bottomBlock(class_2680 s) {
            this.bottomBlock = class_4651.method_38433((class_2680)s);
            return this;
        }

        public Builder<T> tripleShape(class_2248 s) {
            return this.tripleShape(s.method_9564());
        }

        public Builder<T> tripleShape(class_2680 s) {
            this.block((class_2680)s.method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
            this.tipBlock((class_2680)s.method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
            this.bottomBlock((class_2680)s.method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
            return this;
        }

        public Builder<T> tripleShapeCeil(class_2248 s) {
            return this.tripleShapeCeil(s.method_9564());
        }

        public Builder<T> tripleShapeCeil(class_2680 s) {
            this.block((class_2680)s.method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
            this.tipBlock((class_2680)s.method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
            this.bottomBlock((class_2680)s.method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
            return this;
        }

        public Builder<T> block(class_4651 s) {
            this.clusterBlock = s;
            if (this.tipBlock == null) {
                this.tipBlock = s;
            }
            if (this.bottomBlock == null) {
                this.bottomBlock = s;
            }
            return this;
        }

        public Builder<T> tipBlock(class_4651 s) {
            this.tipBlock = s;
            return this;
        }

        public Builder<T> bottomBlock(class_4651 s) {
            this.bottomBlock = s;
            return this;
        }

        public Builder<T> heightRange(int min, int max) {
            this.minHeight = min;
            this.maxHeight = max;
            return this;
        }

        public Builder<T> growWhileFree() {
            this.growWhileFree = true;
            return this;
        }

        public Builder<T> minHeight(int h) {
            this.minHeight = h;
            return this;
        }

        public Builder<T> maxHeight(int h) {
            this.maxHeight = h;
            return this;
        }

        public Builder<T> generateBaseBlock(class_2680 baseState) {
            return this.generateBaseBlock(baseState, 1.0f, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> generateBaseBlock(class_2680 baseState, float baseReplaceChance) {
            return this.generateBaseBlock(baseState, baseReplaceChance, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> generateBaseBlock(class_2680 baseState, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3) {
            return this.generateBaseBlock(baseState, 1.0f, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3);
        }

        public Builder<T> generateBaseBlock(class_2680 baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3) {
            if (this.baseState.isPresent() && this.baseReplaceChance == 0.0f) {
                BCLib.LOGGER.error("Base generation was already selected.");
            }
            this.baseState = Optional.of(baseState);
            this.baseReplaceChance = baseReplaceChance;
            this.chanceOfDirectionalSpread = chanceOfDirectionalSpread;
            this.chanceOfSpreadRadius2 = chanceOfSpreadRadius2;
            this.chanceOfSpreadRadius3 = chanceOfSpreadRadius3;
            return this;
        }

        public Builder<T> noSpread() {
            return this.spread(0.0f, 0.0f, (class_6017)class_6016.method_34998((int)0));
        }

        public Builder<T> spread(float maxSpread, float sizeVariation) {
            return this.spread(maxSpread, sizeVariation, (class_6017)class_6016.method_34998((int)((int)Math.min(16.0f, 4.0f * maxSpread * maxSpread))));
        }

        public Builder<T> spread(float maxSpread, float sizeVariation, class_6017 spreadCount) {
            this.spreadCount = spreadCount;
            this.maxSpread = maxSpread;
            this.sizeVariation = sizeVariation;
            return this;
        }

        public Builder<T> floorChance(float chance) {
            this.floorChance = chance;
            return this;
        }

        public Builder<T> onFloor() {
            this.floorChance = 1.0f;
            return this;
        }

        public Builder<T> onCeil() {
            this.floorChance = 0.0f;
            return this;
        }

        public T build() {
            return (T)((ScatterFeatureConfig)this.instancer.apply(this.clusterBlock, Optional.of(this.tipBlock), Optional.of(this.bottomBlock), this.baseState, Float.valueOf(this.baseReplaceChance), Float.valueOf(this.chanceOfDirectionalSpread), Float.valueOf(this.chanceOfSpreadRadius2), Float.valueOf(this.chanceOfSpreadRadius3), this.minHeight, this.maxHeight, Float.valueOf(this.maxSpread), Float.valueOf(this.sizeVariation), Float.valueOf(this.floorChance), this.growWhileFree, this.spreadCount));
        }
    }

    public static class ExtendBottom
    extends ScatterFeatureConfig {
        public static final Codec<ExtendBottom> CODEC = ExtendBottom.buildCodec(ExtendBottom::new);

        protected ExtendBottom(class_4651 clusterBlock, Optional<class_4651> tipBlock, Optional<class_4651> bottomBlock, Optional<class_2680> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, class_6017 spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        @Override
        public boolean isValidBase(class_2680 state) {
            return BlocksHelper.isTerrain(state) || this.baseState.map(s -> state.method_27852(s.method_26204())).orElse(false) != false;
        }

        @Override
        public class_2680 createBlock(int height, int maxHeight, class_5819 random, class_2338 pos) {
            if (height == maxHeight) {
                return this.tipBlock.method_23455(random, pos);
            }
            if (height == maxHeight - 1) {
                return this.clusterBlock.method_23455(random, pos);
            }
            return this.bottomBlock.method_23455(random, pos);
        }
    }

    public static class ExtendTop
    extends ScatterFeatureConfig {
        public static final Codec<ExtendTop> CODEC = ExtendTop.buildCodec(ExtendTop::new);

        protected ExtendTop(class_4651 clusterBlock, Optional<class_4651> tipBlock, Optional<class_4651> bottomBlock, Optional<class_2680> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, class_6017 spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        @Override
        public boolean isValidBase(class_2680 state) {
            return BlocksHelper.isTerrain(state) || this.baseState.map(s -> state.method_27852(s.method_26204())).orElse(false) != false;
        }

        @Override
        public class_2680 createBlock(int height, int maxHeight, class_5819 random, class_2338 pos) {
            if (height == 0) {
                return this.bottomBlock.method_23455(random, pos);
            }
            if (height == 1) {
                return this.clusterBlock.method_23455(random, pos);
            }
            return this.tipBlock.method_23455(random, pos);
        }
    }

    public static class OnSolid
    extends ScatterFeatureConfig {
        public static final Codec<OnSolid> CODEC = OnSolid.buildCodec(OnSolid::new);

        protected OnSolid(class_4651 clusterBlock, Optional<class_4651> tipBlock, Optional<class_4651> bottomBlock, Optional<class_2680> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, class_6017 spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        @Override
        public boolean isValidBase(class_2680 state) {
            return BlocksHelper.isTerrain(state) || this.baseState.map(s -> state.method_27852(s.method_26204())).orElse(false) != false;
        }

        @Override
        public class_2680 createBlock(int height, int maxHeight, class_5819 random, class_2338 pos) {
            if (height == 0) {
                return this.bottomBlock.method_23455(random, pos);
            }
            return height == maxHeight ? this.tipBlock.method_23455(random, pos) : this.clusterBlock.method_23455(random, pos);
        }
    }
}

