/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.ambertation.wunderlib.ui.layout.components.render.ScrollerRenderer;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import net.minecraft.client.renderer.GameRenderer;

public class VanillaScrollerRenderer
implements ScrollerRenderer {
    public static final VanillaScrollerRenderer DEFAULT = new VanillaScrollerRenderer();

    @Override
    public void renderScrollBar(Rectangle b, int pickerOffset, int pickerSize, float zIndex) {
        b = this.getScrollerBounds(b);
        Rectangle p = this.getPickerBounds(b, pickerOffset, pickerSize);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferBuilder.addVertex((float)b.left, (float)b.bottom(), zIndex).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)b.right(), (float)b.bottom(), zIndex).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)b.right(), (float)b.top, zIndex).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)b.left, (float)b.top, zIndex).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)p.left, (float)p.bottom(), zIndex).setColor(128, 128, 128, 255);
        bufferBuilder.addVertex((float)p.right(), (float)p.bottom(), zIndex).setColor(128, 128, 128, 255);
        bufferBuilder.addVertex((float)p.right(), (float)p.top, zIndex).setColor(128, 128, 128, 255);
        bufferBuilder.addVertex((float)p.left, (float)p.top, zIndex).setColor(128, 128, 128, 255);
        bufferBuilder.addVertex((float)p.left, (float)(p.bottom() - 1), zIndex).setColor(192, 192, 192, 255);
        bufferBuilder.addVertex((float)(p.right() - 1), (float)(p.bottom() - 1), zIndex).setColor(192, 192, 192, 255);
        bufferBuilder.addVertex((float)(p.right() - 1), (float)p.top, zIndex).setColor(192, 192, 192, 255);
        bufferBuilder.addVertex((float)p.left, (float)p.top, zIndex).setColor(192, 192, 192, 255);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

