/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class LayoutScreen
extends Screen {
    protected static final Runnable EMPTY_SCREEN = () -> Minecraft.getInstance().setScreen(null);
    protected final int topPadding;
    protected final int bottomPadding;
    protected final int sidePadding;
    protected final int titleSpacing;
    private OverlayProvider overlayProvider = null;
    private Panel currentOverlay = null;
    @Nullable
    protected Panel main;
    @Nullable
    public final Runnable onClose;

    public LayoutScreen(Component component) {
        this(EMPTY_SCREEN, component);
    }

    public LayoutScreen(@Nullable Screen parent, Component component) {
        this(LayoutScreen.setScreenOnClose(parent), component);
    }

    public LayoutScreen(@Nullable Screen parent, Component component, int topPadding, int bottomPadding, int sidePadding) {
        this(LayoutScreen.setScreenOnClose(parent), component, topPadding, bottomPadding, sidePadding);
    }

    public LayoutScreen(@Nullable Runnable onClose, Component component) {
        this(onClose, component, 20, 10, 20, 15);
    }

    public LayoutScreen(@Nullable Runnable onClose, Component component, int topPadding, int bottomPadding, int sidePadding) {
        this(onClose, component, topPadding, bottomPadding, sidePadding, 15);
    }

    public LayoutScreen(@Nullable Runnable onClose, Component component, int topPadding, int bottomPadding, int sidePadding, int titleSpacing) {
        super(component);
        this.onClose = onClose;
        this.topPadding = topPadding;
        this.bottomPadding = bottomPadding;
        this.sidePadding = sidePadding;
        this.titleSpacing = titleSpacing;
    }

    protected abstract LayoutComponent<?, ?> initContent();

    protected void openLink(String uri) {
        ConfirmLinkScreen cls = new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.getPlatform().openUri(uri);
            }
            this.minecraft.setScreen((Screen)this);
        }, uri, true);
        Minecraft.getInstance().setScreen((Screen)cls);
    }

    protected final void init() {
        super.init();
        this.main = new Panel(this, this.width, this.height);
        this.main.setChild(this.createScreen(this.initContent()));
        this.main.calculateLayout();
        this.addRenderableWidget((GuiEventListener)this.main);
    }

    protected LayoutComponent<?, ?> createTitle() {
        Text text = (Text)((Text)new Text(LayoutScreen.fit(), LayoutScreen.fit(), this.title).centerHorizontal()).setColor(ColorHelper.WHITE).setDebugName("title");
        return text;
    }

    protected LayoutComponent<?, ?> createScreen(LayoutComponent<?, ?> content) {
        VerticalStack rows = (VerticalStack)new VerticalStack(LayoutScreen.fill(), LayoutScreen.fill()).setDebugName("title stack");
        if (this.topPadding > 0) {
            rows.addSpacer(this.topPadding);
        }
        rows.add((LayoutComponent)this.createTitle());
        rows.addSpacer(this.titleSpacing);
        rows.add((LayoutComponent)content);
        if (this.bottomPadding > 0) {
            rows.addSpacer(this.bottomPadding);
        }
        if (this.sidePadding <= 0) {
            return rows;
        }
        HorizontalStack cols = (HorizontalStack)new HorizontalStack(LayoutScreen.fill(), LayoutScreen.fill()).setDebugName("padded side");
        cols.addSpacer(this.sidePadding);
        cols.add((LayoutComponent)rows);
        cols.addSpacer(this.sidePadding);
        return cols;
    }

    public void renderBackgroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackgroundLayer(guiGraphics, i, j, f);
        super.render(guiGraphics, i, j, f);
    }

    protected static Runnable setScreenOnClose(Screen screen) {
        if (screen == null) {
            return EMPTY_SCREEN;
        }
        return () -> Minecraft.getInstance().setScreen(screen);
    }

    protected final void closeScreen() {
        this.onClose();
    }

    public void onClose() {
        if (this.onClose != null) {
            this.onClose.run();
        } else {
            Minecraft.getInstance().setScreen(null);
        }
    }

    public boolean isPauseScreen() {
        return true;
    }

    public static Value fit() {
        return Value.fit();
    }

    public static Value fitOrFill() {
        return Value.fitOrFill();
    }

    public static Value fill() {
        return Value.fill();
    }

    public static Value fixed(int size) {
        return Value.fixed(size);
    }

    public static Value relative(double percentage) {
        return Value.relative(percentage);
    }

    public static MutableComponent translatable(String key) {
        return Component.translatable((String)key);
    }

    public static MutableComponent literal(String content) {
        return Component.literal((String)content);
    }

    public void setOverlayProvider(OverlayProvider newOverlay) {
        if (this.overlayProvider != null) {
            this.overlayProvider.willRemoveOverlay();
        }
        if (this.currentOverlay != null) {
            this.removeWidget((GuiEventListener)this.currentOverlay);
            this.currentOverlay = null;
        }
        this.overlayProvider = newOverlay;
        if (this.overlayProvider != null) {
            this.currentOverlay = this.overlayProvider.getOverlay();
            this.addRenderableWidget((GuiEventListener)this.currentOverlay);
        }
    }

    public static interface OverlayProvider {
        @NotNull
        public Panel getOverlay();

        public void willRemoveOverlay();
    }
}

