/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components.input;

import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;

@Environment(value=EnvType.CLIENT)
public interface RelativeContainerEventHandler
extends ContainerEventHandler {
    public Rectangle getInputBounds();

    default public Optional<GuiEventListener> getChildAt(double d, double e) {
        Rectangle r = this.getInputBounds();
        return super.getChildAt(d, e);
    }

    default public boolean mouseClicked(double d, double e, int i) {
        if (this.getFocused() != null) {
            // empty if block
        }
        Rectangle r = this.getInputBounds();
        return super.mouseClicked(d - (double)r.left, e - (double)r.top, i);
    }

    default public boolean mouseReleased(double d, double e, int i) {
        Rectangle r = this.getInputBounds();
        return super.mouseReleased(d - (double)r.left, e - (double)r.top, i);
    }

    default public boolean mouseDragged(double d, double e, int i, double f, double g) {
        Rectangle r = this.getInputBounds();
        return super.mouseDragged(d - (double)r.left, e - (double)r.top, i, f - (double)r.left, g - (double)r.top);
    }

    default public boolean mouseScrolled(double d, double e, double f, double g) {
        Rectangle r = this.getInputBounds();
        return super.mouseScrolled(d - (double)r.left, e - (double)r.top, f, g);
    }

    default public boolean isMouseOver(double x, double y) {
        Rectangle r = this.getInputBounds();
        boolean res = false;
        for (GuiEventListener c : this.children()) {
            res |= c.isMouseOver(x - (double)r.left, y - (double)r.top);
        }
        return res || r.contains(x, y);
    }
}

