/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.CustomRenderComponent;
import de.ambertation.wunderlib.ui.layout.components.render.RenderHelper;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;

@Environment(value=EnvType.CLIENT)
public class VLine
extends CustomRenderComponent {
    private int color = ColorHelper.DEFAULT_TEXT;
    private boolean focused;

    public VLine(Value width, Value height) {
        super(width, height);
        this.vAlign = Alignment.CENTER;
        this.hAlign = Alignment.CENTER;
    }

    public VLine setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    protected void customRender(GuiGraphics guiGraphics, int x, int y, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
        int left = bounds.height - this.getContentHeight();
        if (this.hAlign == Alignment.CENTER) {
            left /= 2;
        } else if (this.hAlign == Alignment.MIN) {
            left = 0;
        }
        RenderHelper.vLine(guiGraphics, left, 0, bounds.height, this.color);
    }

    @Override
    public int getContentWidth() {
        return 1;
    }

    @Override
    public int getContentHeight() {
        return 0;
    }

    @Override
    public boolean isMouseOver(double d, double e) {
        return false;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }
}

