/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.ComponentWithBounds;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.input.RelativeContainerEventHandler;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreen;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Panel
implements ComponentWithBounds,
RelativeContainerEventHandler,
NarratableEntry,
Renderable {
    protected LayoutComponent<?, ?> child;
    List<? extends GuiEventListener> listeners = List.of();
    public final Rectangle bounds;
    public final LayoutScreen parentScreen;
    private float zIndex = 0.0f;
    private boolean inputEnabled = true;
    boolean dragging = false;
    GuiEventListener focused;

    public Panel(LayoutScreen parentScreen) {
        this(parentScreen, 0, 0, parentScreen.width, parentScreen.height);
    }

    public Panel(LayoutScreen parentScreen, int width, int height) {
        this(parentScreen, 0, 0, width, height);
    }

    public Panel(LayoutScreen parentScreen, int left, int top, int width, int height) {
        this(parentScreen, new Rectangle(left, top, width, height));
    }

    public Panel(LayoutScreen parentScreen, Rectangle bounds) {
        this.parentScreen = parentScreen;
        this.bounds = bounds;
    }

    public Panel setZIndex(float zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public Panel setChild(LayoutComponent<?, ?> c) {
        this.child = c;
        this.listeners = List.of(c);
        return this;
    }

    public void calculateLayout() {
        if (this.child != null) {
            this.child.calculateLayoutInParent(this);
        }
    }

    @Override
    public Rectangle getRelativeBounds() {
        return this.bounds;
    }

    public List<? extends GuiEventListener> children() {
        return this.listeners;
    }

    @Override
    public Rectangle getInputBounds() {
        return this.bounds;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean bl) {
        this.dragging = bl;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        this.focused = guiEventListener;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks) {
        if (this.child != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.bounds.left, (float)this.bounds.top, this.zIndex);
            this.child.render(guiGraphics, this.inputEnabled ? mouseX - this.bounds.left : -1000, mouseY - this.bounds.top, deltaTicks, this.bounds, this.bounds);
            guiGraphics.pose().popPose();
        }
    }

    public Panel setInputEnabled(boolean inputEnabled) {
        this.inputEnabled = inputEnabled;
        return this;
    }

    @Override
    public boolean mouseClicked(double d, double e, int i) {
        if (this.inputEnabled) {
            return RelativeContainerEventHandler.super.mouseClicked(d, e, i);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (this.inputEnabled) {
            return RelativeContainerEventHandler.super.mouseDragged(d, e, i, f, g);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double d, double e, int i) {
        if (this.inputEnabled) {
            return RelativeContainerEventHandler.super.mouseReleased(d, e, i);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.inputEnabled) {
            return RelativeContainerEventHandler.super.mouseScrolled(d, e, f, g);
        }
        return false;
    }

    public void mouseMoved(double d, double e) {
        if (this.inputEnabled) {
            RelativeContainerEventHandler.super.mouseMoved(d, e);
        }
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        if (this.inputEnabled) {
            return RelativeContainerEventHandler.super.isMouseOver(x, y);
        }
        return false;
    }
}

