/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.CustomRenderComponent;
import de.ambertation.wunderlib.ui.layout.components.render.RenderHelper;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;

@Environment(value=EnvType.CLIENT)
public class ColorSwatch
extends CustomRenderComponent<ColorSwatch> {
    private int color;
    private int borderColor = ColorHelper.BLACK;
    private boolean offsetInner = false;
    private boolean focused;

    public ColorSwatch(Value width, Value height, int color) {
        super(width, height);
        this.color = color;
    }

    @Override
    protected void customRender(GuiGraphics guiGraphics, int x, int y, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
        int o = this.offsetInner ? 2 : 1;
        RenderHelper.outline(guiGraphics, 0, 0, bounds.width, bounds.height, this.borderColor);
        guiGraphics.fill(o, o, bounds.width - o, bounds.height - o, this.color);
    }

    public int getColor() {
        return this.color;
    }

    public ColorSwatch setColor(int color) {
        this.color = color;
        return this;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public ColorSwatch setBorderColor(int color) {
        this.borderColor = color;
        return this;
    }

    public boolean getOffsetInner() {
        return this.offsetInner;
    }

    public ColorSwatch setOffsetInner(boolean val) {
        this.offsetInner = val;
        return this;
    }

    @Override
    public int getContentWidth() {
        return 20;
    }

    @Override
    public int getContentHeight() {
        return 20;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }
}

