/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import de.ambertation.wunderlib.WunderLib;
import java.io.File;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ItemHelper {
    private ItemHelper() {
    }

    public static void renderAll(@NotNull Stream<Item> items, @NotNull File folder) {
        ItemHelper.renderAll(items, 8.0f, folder);
    }

    public static void renderAll(@NotNull Stream<Item> items, float scale, @NotNull File folder) {
        folder.mkdirs();
        items.forEach(item -> {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey(item);
            File subFolder = new File(folder, id.getNamespace());
            subFolder.mkdirs();
            ItemStack stack = new ItemStack((ItemLike)item);
            File file = new File(subFolder, id.getPath() + ".png");
            ItemHelper.renderToFile(stack, scale, file);
        });
    }

    public static void renderToFile(@NotNull ItemLike item, @NotNull File file) {
        ItemHelper.renderToFile(new ItemStack(item), null, 8.0f, file);
    }

    public static void renderToFile(@NotNull ItemStack stack, @NotNull File file) {
        ItemHelper.renderToFile(stack, null, 8.0f, file);
    }

    public static void renderToFile(@NotNull ItemStack stack, float scale, @NotNull File file) {
        ItemHelper.renderToFile(stack, null, scale, file);
    }

    public static void renderToFile(@NotNull ItemStack stack, @Nullable String overlayText, float scale, @NotNull File file) {
        RenderSystem.recordRenderCall(() -> {
            RenderTarget framebuffer = ItemHelper.createRenderContext((int)(16.0f * scale), (int)(16.0f * scale));
            ItemHelper.renderToFramebuffer(stack, overlayText, scale, framebuffer);
            ItemHelper.write(framebuffer, file);
        });
    }

    private static RenderTarget createRenderContext(int width, int height) {
        TextureTarget framebuffer = new TextureTarget(width, height, true, Minecraft.ON_OSX);
        framebuffer.setClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        return framebuffer;
    }

    private static void renderToFramebuffer(ItemStack stack, String text, float scale, RenderTarget framebuffer) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.viewport((int)0, (int)0, (int)framebuffer.viewWidth, (int)framebuffer.viewHeight);
        framebuffer.bindWrite(true);
        RenderBuffers renderBuffers = minecraft.renderBuffers();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)framebuffer.viewWidth / scale, (float)framebuffer.viewHeight / scale, 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.disableDepthTest();
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushMatrix();
        poseStack.identity();
        poseStack.translate(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        MultiBufferSource.BufferSource bufferSource = renderBuffers.bufferSource();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        guiGraphics.renderFakeItem(stack, 0, 0);
        if (stack.getCount() > 1 && text == null) {
            text = String.valueOf(stack.getCount());
        }
        if (text != null) {
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, 0, 0, text);
        }
        guiGraphics.flush();
        poseStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        framebuffer.unbindWrite();
        minecraft.getMainRenderTarget().bindWrite(true);
    }

    private static NativeImage takeScreenshot(RenderTarget renderTarget) {
        NativeImage nativeImage = new NativeImage(renderTarget.width, renderTarget.height, false);
        RenderSystem.bindTexture((int)renderTarget.getColorTextureId());
        nativeImage.downloadTexture(0, false);
        nativeImage.flipY();
        return nativeImage;
    }

    private static void write(RenderTarget framebuffer, File file2) {
        NativeImage img = ItemHelper.takeScreenshot(framebuffer);
        Util.ioPool().execute(() -> {
            try {
                img.writeToFile(file2);
            }
            catch (Exception exception) {
                WunderLib.LOGGER.warn("Couldn't save screenshot", exception);
            }
            finally {
                img.close();
            }
        });
    }
}

