/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.network;

import de.ambertation.wunderlib.network.NetworkPayload;
import de.ambertation.wunderlib.network.PacketHandler;
import de.ambertation.wunderlib.network.SendToServerAdapter;
import de.ambertation.wunderlib.network.ServerBoundNetworkPayload;
import de.ambertation.wunderlib.utils.EnvHelper;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.jetbrains.annotations.ApiStatus;

public class ServerBoundPacketHandler<T extends ServerBoundNetworkPayload<T>>
extends PacketHandler<T> {
    private static SendToServerAdapter sendToServerAdapter;

    @ApiStatus.Internal
    static void registerAdapter(SendToServerAdapter adapter) {
        sendToServerAdapter = adapter;
    }

    public ServerBoundPacketHandler(ResourceLocation channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        super(channel, factory);
    }

    public static <T extends ServerBoundNetworkPayload<T>> void register(ServerBoundPacketHandler<T> packetHandler) {
        PayloadTypeRegistry.playC2S().register(packetHandler.CHANNEL, packetHandler.STREAM_CODEC);
        ServerPlayConnectionEvents.INIT.register((handler, server) -> ServerPlayNetworking.registerReceiver((ServerGamePacketListenerImpl)handler, (CustomPacketPayload.Type)packetHandler.CHANNEL, packetHandler::receiveOnServer));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerPlayNetworking.unregisterReceiver((ServerGamePacketListenerImpl)handler, (ResourceLocation)packetHandler.CHANNEL.id()));
    }

    public static <T extends ServerBoundNetworkPayload<T>> ServerBoundPacketHandler<T> register(ResourceLocation channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        ServerBoundPacketHandler<T> packetHandler = new ServerBoundPacketHandler<T>(channel, factory);
        ServerBoundPacketHandler.register(packetHandler);
        return packetHandler;
    }

    public static <T extends ServerBoundNetworkPayload<T>> void sendToServer(T payload) {
        if (EnvHelper.isClient() && sendToServerAdapter != null) {
            payload.prepareOnClient();
            sendToServerAdapter.sendToServer(payload);
        }
    }

    private void receiveOnServer(T payload, ServerPlayNetworking.Context context) {
        ((ServerBoundNetworkPayload)payload).processOnServer(context.player(), context.responseSender());
        Runnable runner = () -> payload.processOnGameThread(context.player().getServer(), context.player());
        MinecraftServer server = context.player().getServer();
        if (server != null) {
            if (((NetworkPayload)payload).isBlocking()) {
                server.executeBlocking(runner);
            } else {
                server.execute(runner);
            }
        }
    }
}

