/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import de.ambertation.wunderlib.WunderLib;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDFDifference;
import de.ambertation.wunderlib.math.sdf.SDFIntersection;
import de.ambertation.wunderlib.math.sdf.SDFInvert;
import de.ambertation.wunderlib.math.sdf.SDFUnion;
import de.ambertation.wunderlib.math.sdf.interfaces.Transformable;
import de.ambertation.wunderlib.math.sdf.shapes.Box;
import de.ambertation.wunderlib.math.sdf.shapes.Cylinder;
import de.ambertation.wunderlib.math.sdf.shapes.Ellipsoid;
import de.ambertation.wunderlib.math.sdf.shapes.Empty;
import de.ambertation.wunderlib.math.sdf.shapes.Sphere;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class SDF {
    private Matrix4 rootTransform;
    protected final SDF[] inputSlots;
    protected int graphIndex = 0;
    private SDF parent;
    public static final MappedRegistry<MapCodec<? extends SDF>> SDF_REGISTRY = (MappedRegistry)FabricRegistryBuilder.createSimple(null, (ResourceLocation)WunderLib.ID("sdf")).attribute(RegistryAttribute.MODDED).buildAndRegister();
    public static final Codec<SDF> CODEC = SDF_REGISTRY.byNameCodec().dispatch(sdf -> sdf.codec().codec(), Function.identity());

    protected SDF(int inputCount) {
        this.inputSlots = new SDF[inputCount];
    }

    public void setRootTransform(Matrix4 m) {
        if (this.parent == null) {
            this.rootTransform = m;
        } else {
            this.parent.setRootTransform(m);
        }
    }

    @NotNull
    public Matrix4 getRootTransform() {
        if (this.parent == null) {
            return this.rootTransform == null ? Matrix4.IDENTITY : this.rootTransform;
        }
        return this.parent.getRootTransform();
    }

    public Transform getLocalTransform() {
        return Transform.IDENTITY;
    }

    public Matrix4 getWorldTransformMatrix() {
        return this.getParentTransformMatrix().mul(this.getLocalTransform().asMatrix());
    }

    public Matrix4 getParentTransformMatrix() {
        if (this.parent == null) {
            return this.rootTransform == null ? Matrix4.IDENTITY : this.rootTransform;
        }
        return this.parent.getWorldTransformMatrix();
    }

    public int getInputSlotCount() {
        return this.inputSlots.length;
    }

    public boolean hasInputSlots() {
        return this.inputSlots.length > 0;
    }

    public SDF getSlot(int idx) {
        return this.inputSlots[idx];
    }

    public boolean hasInputs() {
        for (SDF inputSlot : this.inputSlots) {
            if (inputSlot == null || inputSlot instanceof Empty) continue;
            return true;
        }
        return false;
    }

    void setSlotSilent(int idx, SDF sdf) {
        if (this.inputSlots[idx] != sdf && this.inputSlots[idx] != null) {
            this.inputSlots[idx].setParent(null);
            this.inputSlots[idx].setGraphIndexRecursive(0);
        }
        this.inputSlots[idx] = sdf == null ? new Empty() : sdf;
        this.inputSlots[idx].setParent(this);
        if (idx == 0) {
            this.inputSlots[idx].setGraphIndexRecursive(this.graphIndex + 1);
        } else {
            this.inputSlots[idx].setGraphIndexRecursive(this.inputSlots[idx - 1].maxGraphIndex() + 1);
        }
    }

    public void setSlot(int idx, SDF sdf) {
        this.setSlotSilent(idx, sdf);
    }

    public int inputSlotIndex(SDF sdf) {
        for (int i = 0; i < this.inputSlots.length; ++i) {
            if (this.inputSlots[i] != sdf) continue;
            return i;
        }
        return -1;
    }

    public boolean replaceInputSlot(SDF currentSDF, SDF newSDF) {
        for (int i = 0; i < this.inputSlots.length; ++i) {
            if (this.inputSlots[i] != currentSDF) continue;
            this.setSlot(i, newSDF);
            return true;
        }
        return false;
    }

    private int setGraphIndexRecursive(int startIndex) {
        this.graphIndex = startIndex;
        for (int i = 0; i < this.inputSlots.length; ++i) {
            startIndex = this.inputSlots[i].setGraphIndexRecursive(startIndex + 1);
        }
        return startIndex;
    }

    private int maxGraphIndex() {
        int idx = this.graphIndex;
        for (int i = 0; i < this.inputSlots.length; ++i) {
            idx = Math.max(idx, this.inputSlots[i].maxGraphIndex());
        }
        return idx;
    }

    public int getGraphIndex() {
        return this.graphIndex;
    }

    public SDF getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public SDF getChildWithGraphIndex(int gIdx) {
        if (gIdx == this.graphIndex) {
            return this;
        }
        for (int i = 0; i < this.inputSlots.length; ++i) {
            SDF s = this.inputSlots[i].getChildWithGraphIndex(gIdx);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public Bounds getBoundingBox() {
        Bounds b = Bounds.EMPTY;
        for (SDF sdf : this.inputSlots) {
            b = b.encapsulate(sdf.getBoundingBox());
        }
        return b;
    }

    public Bounds getLocalBoundingBox(Matrix4 m) {
        Bounds b = Bounds.EMPTY;
        for (SDF sdf : this.inputSlots) {
            Matrix4 matrix4;
            if (sdf instanceof Transformable) {
                Transformable tf = (Transformable)((Object)sdf);
                matrix4 = tf.getLocalTransform().asMatrix().mul(m);
            } else {
                matrix4 = m;
            }
            Matrix4 mm = matrix4;
            b = b.encapsulate(sdf.getLocalBoundingBox(mm));
        }
        return b;
    }

    public abstract Transform defaultTransform();

    void setParent(SDF parent) {
        this.parent = parent;
    }

    public SDF getParent() {
        return this.parent;
    }

    public void dist(EvaluationData d, Float3 pos) {
        d.dist = this.dist(pos);
        d.source = this;
    }

    public void evaluate(PlaceBlock callback, VisitBlock visitor) {
        this.evaluate(this.getBoundingBox(), callback, visitor);
    }

    public void evaluate(Bounds bBox, PlaceBlock callback, VisitBlock visitor) {
        EvaluationData ed = new EvaluationData();
        if (bBox.volume() > 32768.0) {
            return;
        }
        Float3 min = bBox.min.mul(2.0).round().div(2.0);
        Float3 max = bBox.max.mul(2.0).round().div(2.0);
        for (double xx = min.x - 2.0; xx < max.x + 2.0; xx += 1.0) {
            for (double xy = min.y - 2.0; xy < max.y + 2.0; xy += 1.0) {
                for (double xz = min.z - 2.0; xz < max.z + 2.0; xz += 1.0) {
                    Float3 p = Float3.of(xx, xy, xz);
                    Float3 pMid = p.sub(0.5).blockAligned();
                    this.dist(ed, p);
                    double dist = (double)Math.round(ed.dist() * 80.0) / 80.0;
                    boolean didPlace = false;
                    if (dist <= 0.5 && dist >= -0.5) {
                        int sign = 0;
                        for (Bounds.Interpolate offset : Bounds.Interpolate.CORNERS) {
                            Float3 pd = p.add(offset.t.sub(0.5));
                            double dd = this.dist(pd);
                            dd = (double)Math.round(dd * 80.0) / 80.0;
                            if (sign == 0) {
                                sign = dd < 0.0 ? -1 : 1;
                                continue;
                            }
                            if ((dd < 0.0 ? -1 : 1) == sign) continue;
                            didPlace = true;
                            callback.place(pMid, ed);
                            if (visitor == null) break;
                            visitor.visit(p, ed, true);
                            break;
                        }
                    }
                    if (didPlace || visitor == null) continue;
                    visitor.visit(p, ed, false);
                }
            }
        }
    }

    public abstract double dist(Float3 var1);

    public abstract KeyDispatchDataCodec<? extends SDF> codec();

    static void bootstrap(Registry<MapCodec<? extends SDF>> registry) {
        SDF.register(registry, "union", SDFUnion.CODEC);
        SDF.register(registry, "intersect", SDFIntersection.CODEC);
        SDF.register(registry, "dif", SDFDifference.CODEC);
        SDF.register(registry, "invert", SDFInvert.CODEC);
        SDF.register(registry, "empty", Empty.CODEC);
        SDF.register(registry, "sphere", Sphere.CODEC);
        SDF.register(registry, "box", Box.CODEC);
        SDF.register(registry, "cylinder", Cylinder.CODEC);
        SDF.register(registry, "ellipsoid", Ellipsoid.CODEC);
    }

    static MapCodec<? extends SDF> register(Registry<MapCodec<? extends SDF>> registry, String name, KeyDispatchDataCodec<? extends SDF> codec) {
        return (MapCodec)Registry.register(registry, (ResourceLocation)WunderLib.ID(name), (Object)codec.codec());
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
        SDF.bootstrap(SDF_REGISTRY);
    }

    public static final class EvaluationData {
        double dist;
        SDF source;

        public EvaluationData() {
            this(Double.MAX_VALUE, new Empty());
        }

        public EvaluationData(double dist, SDF source) {
            this.dist = dist;
            this.source = source;
        }

        public double dist() {
            return this.dist;
        }

        public SDF source() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            EvaluationData that = (EvaluationData)obj;
            return Double.doubleToLongBits(this.dist) == Double.doubleToLongBits(that.dist) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.dist, this.source);
        }

        public String toString() {
            return "EvaluationData[dist=" + this.dist + ", source=" + String.valueOf(this.source) + "]";
        }
    }

    @FunctionalInterface
    public static interface PlaceBlock {
        public void place(Float3 var1, EvaluationData var2);
    }

    @FunctionalInterface
    public static interface VisitBlock {
        public void visit(Float3 var1, EvaluationData var2, boolean var3);
    }
}

