/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Quaternion;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class Transform {
    public static final Transform IDENTITY = new Transform(Float3.ZERO, Float3.IDENTITY, Quaternion.IDENTITY);
    public static final MapCodec<Transform> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Float3.CODEC.fieldOf("center").orElse((Object)Float3.ZERO).forGetter(o -> o.center), (App)Float3.CODEC.fieldOf("size").orElse((Object)Float3.IDENTITY).forGetter(o -> o.size), (App)Quaternion.CODEC.fieldOf("rotation").orElse((Object)Quaternion.IDENTITY).forGetter(o -> o.rotation)).apply((Applicative)instance, Transform::new));
    public final Float3 center;
    public final Float3 size;
    public final Quaternion rotation;

    protected Transform(Float3 center, Float3 size, Quaternion rotation) {
        this.center = center;
        this.size = size;
        this.rotation = rotation;
    }

    public static Transform of(Float3 center, Float3 size, Quaternion rotation) {
        return new Transform(center, size, rotation);
    }

    public static Transform of(Float3 center, Float3 size) {
        return new Transform(center, size, Quaternion.IDENTITY);
    }

    public static Transform ofTranslation(Float3 center) {
        return new Transform(center, Float3.IDENTITY, Quaternion.IDENTITY);
    }

    public static Transform of(Bounds b) {
        return new Transform(b.getCenter(), b.getSize(), Quaternion.IDENTITY);
    }

    public Bounds getBoundingBoxWorldSpace() {
        return this.getBoundingBoxWorldSpace(Matrix4.IDENTITY);
    }

    public Bounds getBoundingBoxWorldSpace(Matrix4 parentTransform) {
        Bounds b = Bounds.EMPTY;
        for (Float3 c : this.getCornersInWorldSpace(false, parentTransform)) {
            b = b.encapsulate(c);
        }
        return b;
    }

    public Bounds getBoundingBoxUnrotated() {
        return Bounds.ofBox(this.center, this.size);
    }

    public Float3[] getCornersInWorldSpace() {
        return this.getCornersInWorldSpace(false);
    }

    public Float3[] getCornersInWorldSpace(boolean blockAligned) {
        Float3[] corners = new Float3[Bounds.Interpolate.CORNERS.length];
        for (int i = 0; i < Bounds.Interpolate.CORNERS.length; ++i) {
            corners[i] = this.transform(Bounds.Interpolate.CORNERS[i].t.sub(0.5));
            if (!blockAligned) continue;
            corners[i] = corners[i].blockAligned();
        }
        return corners;
    }

    public Float3[] getCornersAndCenterInWorldSpace(boolean blockAligned, Matrix4 toWorldMatrix) {
        return toWorldMatrix.mul(this.asMatrix()).getUnitCubeCornersAndCenter(blockAligned);
    }

    public Float3[] getCornersInWorldSpace(boolean blockAligned, Matrix4 toWorldMatrix) {
        return toWorldMatrix.mul(this.asMatrix()).getUnitCubeCorners(blockAligned);
    }

    public Float3 getCornerInWorldSpace(Bounds.Interpolate corner, boolean blockAligned, Matrix4 toWorldMatrix) {
        return toWorldMatrix.mul(this.asMatrix()).getUnitCubeCorner(corner, blockAligned);
    }

    public Transform translate(Float3 offset) {
        if (offset == null) {
            return this;
        }
        return new Transform(this.center.add(offset), this.size, this.rotation);
    }

    public Transform translate(Vec3 offset) {
        if (offset == null) {
            return this;
        }
        return new Transform(this.center.add(offset), this.size, this.rotation);
    }

    public Transform translateInverted(Float3 offset) {
        if (offset == null) {
            return this;
        }
        return new Transform(this.center.sub(offset), this.size, this.rotation);
    }

    public Transform translateInverted(Vec3 offset) {
        if (offset == null) {
            return this;
        }
        return new Transform(this.center.sub(offset), this.size, this.rotation);
    }

    public Transform scaleBy(Float3 scale) {
        if (scale == null) {
            return this;
        }
        return new Transform(this.center, this.size.mul(scale), this.rotation);
    }

    public Transform setScale(Float3 scale) {
        if (scale == null) {
            scale = Float3.IDENTITY;
        }
        return new Transform(this.center, scale, this.rotation);
    }

    public Transform moveTo(Float3 newCenter) {
        if (newCenter == null) {
            newCenter = Float3.ZERO;
        }
        return new Transform(newCenter, this.size, this.rotation);
    }

    public Transform moveBy(Float3 offset) {
        if (offset == null) {
            return this;
        }
        return new Transform(this.center.add(offset), this.size, this.rotation);
    }

    public Transform rotateBy(Quaternion rotation) {
        if (rotation == null) {
            return this;
        }
        return new Transform(this.center, this.size, this.rotation.mul(rotation));
    }

    public Transform rotateBy(Float3 normalizedAxis, double angle) {
        if (normalizedAxis == null || angle == 0.0) {
            return this;
        }
        return new Transform(this.center, this.size, this.rotation.mul(Quaternion.ofAxisAngle(normalizedAxis, angle)));
    }

    public Transform setRotation(Quaternion rotation) {
        if (rotation == null) {
            rotation = Quaternion.IDENTITY;
        }
        return new Transform(this.center, this.size, rotation);
    }

    public Float3 transform(Float3 p) {
        return p.mul(this.size).rotate(this.rotation).add(this.center);
    }

    public Float3 unTransform(Float3 p) {
        return p.sub(this.center).unRotate(this.rotation).div(this.size);
    }

    public Transform addScale(double sx, double sy, double sz) {
        return new Transform(this.center, this.size.add(sx, sy, sz), this.rotation);
    }

    public Matrix4 asMatrix() {
        return Matrix4.ofTranslation(this.center).mul(Matrix4.ofRotation(this.rotation)).mul(Matrix4.ofScale(this.size));
    }

    public Matrix4 asInvertedMatrix() {
        return Matrix4.ofScale(this.size.reciprocal()).mul(Matrix4.ofRotation(this.rotation.inverted())).mul(Matrix4.ofTranslation(this.center.mul(-1.0)));
    }

    public String toString() {
        return "Transform{c=" + String.valueOf(this.center) + ", s=" + String.valueOf(this.size) + ", r=" + String.valueOf(this.rotation) + "}";
    }

    public void serializeToNetwork(FriendlyByteBuf buf) {
        this.center.serializeToNetwork(buf);
        this.size.serializeToNetwork(buf);
        this.rotation.serializeToNetwork(buf);
    }

    public static Transform deserializeFromNetwork(FriendlyByteBuf buf) {
        Float3 c = Float3.deserializeFromNetwork(buf);
        Float3 s = Float3.deserializeFromNetwork(buf);
        Quaternion r = Quaternion.deserializeFromNetwork(buf);
        return new Transform(c, s, r);
    }
}

