/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.configs;

import de.ambertation.wunderlib.configs.AbstractConfig;
import de.ambertation.wunderlib.configs.ConfigFile;
import de.ambertation.wunderlib.utils.Version;
import java.util.Collection;
import java.util.HashMap;

public class DynamicConfig<T>
extends ConfigFile {
    private static final boolean DEFAULT_VALUE = true;
    private final HashMap<String, AbstractConfig.BooleanValue> dynamicConfig = new HashMap();
    private final HashMap<T, AbstractConfig.BooleanValue> dynamicLookup = new HashMap();

    public DynamicConfig(Version.ModVersionProvider versionProvider, String category) {
        super(versionProvider, category);
    }

    public AbstractConfig.BooleanValue booleanOrDefault(String name) {
        if (this.dynamicConfig.containsKey(name)) {
            return this.dynamicConfig.get(name);
        }
        return (AbstractConfig)this.new AbstractConfig.BooleanValue("", name, true);
    }

    public AbstractConfig.BooleanValue newBooleanFor(String name, T object) {
        if (this.dynamicConfig.containsKey(name)) {
            return this.dynamicConfig.get(name);
        }
        AbstractConfig.BooleanValue bv = (AbstractConfig)this.new AbstractConfig.BooleanValue("", name, true);
        this.dynamicConfig.put(name, bv);
        this.dynamicLookup.put(object, bv);
        return bv;
    }

    public AbstractConfig.BooleanValue valueOf(String object) {
        return this.dynamicConfig.get(object);
    }

    public boolean valueOf(T object) {
        if (object == null) {
            return false;
        }
        AbstractConfig.BooleanValue bv = this.dynamicLookup.get(object);
        if (bv == null) {
            return false;
        }
        return (Boolean)bv.get();
    }

    public Collection<T> getAllObjects() {
        return this.dynamicLookup.keySet();
    }
}

