/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.configs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderlib.configs.AbstractConfig;
import de.ambertation.wunderlib.utils.Version;
import java.util.Hashtable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigResource
extends AbstractConfig<ConfigResource> {
    private static final String MERGE_STRATEGY = "merge";
    private JsonObject resourceRoot;
    private static Map<String, ConfigResource> CACHED_CONFIGS = new Hashtable<String, ConfigResource>();

    private ConfigResource(Version.ModVersionProvider versionProvider, String path, String category) {
        super(versionProvider, versionProvider.mk("config/" + versionProvider.getNamespace() + "/" + path + ".json"), versionProvider.getNamespace() + "." + path);
    }

    public static void invalidateCache() {
        CACHED_CONFIGS.clear();
    }

    public static ConfigResource create(Version.ModVersionProvider versionProvider, String path) {
        return CACHED_CONFIGS.computeIfAbsent(versionProvider.getNamespace() + "." + path, c -> new ConfigResource(versionProvider, path, (String)c));
    }

    public void setRootElement(String root) {
        this.resourceRoot = (JsonObject)JSON_BUILDER.fromJson(root, JsonObject.class);
    }

    public void setRootElement(JsonObject root) {
        this.resourceRoot = this.resourceRoot == null ? root : ConfigResource.merge(this.resourceRoot, root);
    }

    @Nullable
    protected static JsonObject merge(@Nullable JsonObject oldRoot, @Nullable JsonObject newRoot) {
        MergeStrategy rootStrategy = MergeStrategy.fromString(newRoot != null && newRoot.has(MERGE_STRATEGY) ? newRoot.get(MERGE_STRATEGY).getAsString() : null);
        return ConfigResource.merge(rootStrategy, oldRoot, newRoot);
    }

    @NotNull
    private static JsonPrimitive merge(MergeStrategy rootStrategy, @NotNull JsonPrimitive oldValue, @NotNull JsonPrimitive newValue) {
        if (oldValue.isBoolean() && newValue.isBoolean()) {
            if (rootStrategy == MergeStrategy.OR) {
                return new JsonPrimitive(Boolean.valueOf(oldValue.getAsBoolean() || newValue.getAsBoolean()));
            }
            if (rootStrategy == MergeStrategy.AND) {
                return new JsonPrimitive(Boolean.valueOf(oldValue.getAsBoolean() && newValue.getAsBoolean()));
            }
        }
        return newValue;
    }

    @NotNull
    private static JsonArray merge(@NotNull JsonArray oldValue, @NotNull JsonArray newValue) {
        for (JsonElement e : newValue) {
            oldValue.add(e);
        }
        return oldValue;
    }

    @Nullable
    private static JsonObject merge(MergeStrategy rootStrategy, @Nullable JsonObject oldRoot, @Nullable JsonObject newRoot) {
        if (oldRoot == null) {
            return newRoot;
        }
        if (newRoot == null) {
            return oldRoot;
        }
        if (newRoot.has(MERGE_STRATEGY)) {
            rootStrategy = MergeStrategy.fromString(newRoot.get(MERGE_STRATEGY).getAsString());
        }
        for (Map.Entry e : newRoot.entrySet()) {
            if (((String)e.getKey()).equals(MERGE_STRATEGY)) continue;
            if (!oldRoot.has((String)e.getKey())) {
                oldRoot.add((String)e.getKey(), (JsonElement)e.getValue());
                continue;
            }
            JsonElement newE = (JsonElement)e.getValue();
            JsonElement oldE = oldRoot.get((String)e.getKey());
            if (rootStrategy == MergeStrategy.USE_FIRST) continue;
            if (rootStrategy == MergeStrategy.REPLACE) {
                oldRoot.add((String)e.getKey(), newE);
                continue;
            }
            if (oldE.isJsonObject() && newE.isJsonObject()) {
                oldRoot.add((String)e.getKey(), (JsonElement)ConfigResource.merge(rootStrategy, oldE.getAsJsonObject(), newE.getAsJsonObject()));
                continue;
            }
            if (oldE.isJsonPrimitive() && newE.isJsonPrimitive()) {
                oldRoot.add((String)e.getKey(), (JsonElement)ConfigResource.merge(rootStrategy, oldE.getAsJsonPrimitive(), newE.getAsJsonPrimitive()));
                continue;
            }
            if (oldE.isJsonArray() && newE.isJsonArray()) {
                oldRoot.add((String)e.getKey(), (JsonElement)ConfigResource.merge(oldE.getAsJsonArray(), newE.getAsJsonArray()));
                continue;
            }
            if (!oldE.isJsonArray()) continue;
            JsonArray ar = new JsonArray();
            ar.add(newE);
            oldRoot.add((String)e.getKey(), (JsonElement)ConfigResource.merge(oldE.getAsJsonArray(), ar));
        }
        return oldRoot;
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    @Nullable
    protected JsonObject loadRootElement() {
        return this.resourceRoot;
    }

    @Override
    protected boolean saveRootElement(String root) {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ConfigResource{");
        sb.append("\n      category='").append(this.category).append('\'');
        sb.append(",\n      location='").append(this.location).append('\'');
        sb.append(",\n      resourceRoot=").append(this.resourceRoot);
        sb.append("\n}");
        return sb.toString();
    }

    private static enum MergeStrategy {
        USE_FIRST,
        REPLACE,
        OR,
        AND;


        public static MergeStrategy fromString(String s) {
            if (s == null || s.isEmpty() || s.isBlank()) {
                return USE_FIRST;
            }
            return MergeStrategy.valueOf(s.trim().toUpperCase());
        }
    }
}

