/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderlib.WunderLib;
import de.ambertation.wunderlib.utils.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfig<C extends AbstractConfig<C>> {
    public static final String MODIFY_VERSION = "modify_version";
    public static final String CREATE_VERSION = "create_version";
    static final Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().create();
    public final String category;
    public final ResourceLocation location;
    private final List<Value<?, ?>> knownValues = new LinkedList();
    private JsonObject root;
    private boolean modified;
    private final Version.ModVersionProvider versionProvider;

    public AbstractConfig(Version.ModVersionProvider versionProvider, String category) {
        this(versionProvider, versionProvider.getNamespace(), category);
    }

    public AbstractConfig(Version.ModVersionProvider versionProvider, String namespace, String category) {
        this(versionProvider, versionProvider.mk(category), namespace + "." + category);
    }

    protected AbstractConfig(Version.ModVersionProvider versionProvider, ResourceLocation location, String category) {
        this.category = category;
        this.versionProvider = versionProvider;
        this.location = location;
    }

    void setModified() {
        this.modified = true;
    }

    public int getMaxOrder() {
        int highestOrder = 0;
        for (Value<?, ?> v : this.knownValues) {
            if (v.order <= highestOrder) continue;
            highestOrder = v.order;
        }
        return highestOrder;
    }

    private void registerValue(Value v) {
        this.knownValues.remove(v);
        this.knownValues.add(v);
        v.order = this.getMaxOrder() + 1;
        v.parentFile = this;
    }

    private JsonElement getValue(ConfigToken t, boolean addIfMissing) {
        JsonObject obj = this.getPathElement(t.path, addIfMissing);
        if (!obj.has(t.key)) {
            return null;
        }
        return obj.get(t.key);
    }

    private void setValue(ConfigToken t, JsonElement value) {
        if (!value.equals(this.getValue(t, true))) {
            this.setModified();
        }
        JsonObject obj = this.getPathElement(t.path, true);
        obj.add(t.key, value);
    }

    private void removeValue(ConfigToken t) {
        JsonObject o = this.getPathElement(t.path, false);
        if (o.has(t.key)) {
            WunderLib.LOGGER.info("Removing Config " + t.path + "." + t.key);
            o.remove(t.key);
            this.setModified();
        }
    }

    private JsonObject getPathElement(String path, boolean addIfMissing) {
        if (path == null || path.trim().isEmpty()) {
            return this.root;
        }
        String[] names = path.split("\\.");
        JsonObject obj = this.root;
        for (String p : names) {
            if (obj.has(p)) {
                obj = obj.get(p).getAsJsonObject();
                continue;
            }
            JsonObject newObject = new JsonObject();
            if (addIfMissing) {
                obj.add(p, (JsonElement)newObject);
            }
            obj = newObject;
        }
        return obj;
    }

    boolean isModified() {
        return this.modified && this.root != null;
    }

    @Nullable
    protected abstract JsonObject loadRootElement();

    protected abstract boolean saveRootElement(String var1);

    protected abstract boolean isReadOnly();

    public void loadFromDisc() {
        this.root = this.loadRootElement();
        this.modified = false;
        if (this.root == null) {
            this.root = new JsonObject();
            this.root.add(CREATE_VERSION, (JsonElement)new JsonPrimitive(this.versionProvider.getModVersion().toString()));
        }
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean force) {
        if (!this.isModified() && !force) {
            return;
        }
        if (this.isReadOnly()) {
            this.modified = false;
            return;
        }
        this.root.add(MODIFY_VERSION, (JsonElement)new JsonPrimitive(this.versionProvider.getModVersion().toString()));
        try {
            if (this.saveRootElement(JSON_BUILDER.toJson((JsonElement)this.root))) {
                this.modified = false;
            }
        }
        catch (Exception ex) {
            WunderLib.LOGGER.error("Unable to save Config '{}'.", this.location.toString(), ex);
        }
    }

    private String getVersionString(String name) {
        JsonObject mod = this.getPathElement("", true);
        if (mod == null) {
            return "1.0.0";
        }
        JsonPrimitive p = mod.getAsJsonPrimitive(name);
        if (p == null) {
            return this.versionProvider.getModVersion().toString();
        }
        if (!p.isString()) {
            return "1.0.0";
        }
        return p.getAsString();
    }

    public Version lastModifiedVersion() {
        return new Version(this.getVersionString(MODIFY_VERSION));
    }

    public Version createdVersion() {
        return new Version(this.getVersionString(CREATE_VERSION));
    }

    @Environment(value=EnvType.CLIENT)
    public List<Value<?, ?>> getAllValues() {
        return this.knownValues;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Value<?, ?>> getAllVisibleValues() {
        ArrayList values = new ArrayList();
        for (Value<?, ?> v : this.knownValues) {
            if (v.hiddenInUI) continue;
            values.add(v);
        }
        return values;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Value<?, ?>> getAllVisibleValues(Group group) {
        ArrayList values = new ArrayList();
        for (Value<?, ?> v : this.knownValues) {
            if (v.hiddenInUI || v.group != group) continue;
            values.add(v);
        }
        values.sort(Comparator.comparingInt(o -> o.order));
        return values;
    }

    @Environment(value=EnvType.CLIENT)
    public static List<Value<?, ?>> getAllVisibleValues(Group group, List<AbstractConfig<?>> configFiles) {
        ArrayList values = new ArrayList();
        for (AbstractConfig<?> c : configFiles) {
            for (Value<?, ?> v : c.knownValues) {
                if (v.hiddenInUI || v.group != group) continue;
                values.add(v);
            }
        }
        values.sort(Comparator.comparingInt(o -> o.order));
        return values;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Group> getAllGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Value<?, ?> v : this.knownValues) {
            if (v.group == null || groups.contains(v.group)) continue;
            groups.add(v.group);
        }
        groups.sort(Comparator.comparingInt(o -> o.order));
        return groups;
    }

    @Environment(value=EnvType.CLIENT)
    public static List<Group> getAllGroups(List<AbstractConfig<?>> configFiles) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (AbstractConfig<?> c : configFiles) {
            for (Value<?, ?> v : c.knownValues) {
                if (v.group == null || groups.contains(v.group)) continue;
                groups.add(v.group);
            }
        }
        groups.sort(Comparator.comparingInt(o -> o.order));
        return groups;
    }

    @Environment(value=EnvType.CLIENT)
    public static String getAllCategories(List<AbstractConfig<?>> configFiles) {
        StringBuilder sb = new StringBuilder();
        for (AbstractConfig<?> c : configFiles) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(c.category);
        }
        return sb.toString();
    }

    public Value<?, ?> getValue(String path, String key) {
        for (Value<?, ?> v : this.knownValues) {
            if (!v.token.path().equals(path) || !v.token.key.equals(key)) continue;
            return v;
        }
        return null;
    }

    public abstract class Value<T, R extends Value<T, R>> {
        @NotNull
        public final ConfigToken<T> token;
        @Nullable
        protected Supplier<Boolean> isValidSupplier;
        private boolean hiddenInUI = false;
        @Nullable
        private BooleanValue enabledInUI = null;
        private boolean deprecated = false;
        @Nullable
        private Group group;
        private int order;
        @Nullable
        private C parentFile;
        @Nullable
        private List<AfterChange<C, T, R>> afterChangeNotifications;

        public Value(String path, String key, T defaultValue) {
            this(new ConfigToken<T>(path, key, defaultValue), false);
        }

        public Value(String path, String key, T defaultValue, boolean isDeprecated) {
            this(new ConfigToken<T>(path, key, defaultValue), isDeprecated);
        }

        public Value(ConfigToken token) {
            this(token, false);
        }

        public Value(ConfigToken token, boolean isDeprecated) {
            this.deprecated = isDeprecated;
            this.token = token;
            this.group = null;
            this.get();
            AbstractConfig.this.registerValue(this);
        }

        public R hideInUI() {
            this.hiddenInUI = true;
            return (R)this;
        }

        public R setGroup(Group group) {
            this.group = group;
            return (R)this;
        }

        public R setOrder(int order) {
            this.order = order;
            return (R)this;
        }

        public R setDependency(BooleanValue value) {
            this.enabledInUI = value;
            return (R)this;
        }

        public boolean isHiddenInUI() {
            return this.hiddenInUI;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        @Nullable
        public Group getGroup() {
            return this.group;
        }

        public int getOrder() {
            return this.order;
        }

        @Nullable
        public C getParentFile() {
            return this.parentFile;
        }

        public boolean hasDependency() {
            return this.enabledInUI != null;
        }

        @Nullable
        public BooleanValue getDependency() {
            return this.enabledInUI;
        }

        @Nullable
        public Supplier<Boolean> getIsValidSupplier() {
            return this.isValidSupplier;
        }

        public final T getRaw() {
            JsonElement el = AbstractConfig.this.getValue(this.token, !this.deprecated);
            if (el == null) {
                if (!this.deprecated) {
                    this.set(this.token.defaultValue);
                }
                return this.token.defaultValue;
            }
            return this.convert(el);
        }

        public T get() {
            return this.getRaw();
        }

        public void remove() {
            AbstractConfig.this.removeValue(this.token);
        }

        public void migrate(Value<T, R> newConfig) {
            newConfig.set(this.get());
            this.remove();
        }

        public void notifyAfterChange(AfterChange<C, T, R> notification) {
            if (this.afterChangeNotifications == null) {
                this.afterChangeNotifications = new ArrayList();
            }
            this.afterChangeNotifications.add(notification);
        }

        protected abstract T convert(@NotNull JsonElement var1);

        @NotNull
        protected abstract JsonElement convert(T var1);

        @NotNull
        protected abstract T parseString(@NotNull String var1);

        public void set(T value) {
            if (this.deprecated) {
                throw new IllegalStateException("'" + this.token.path() + "." + this.token.key + "' is deprecated and can no-longer be used");
            }
            AbstractConfig.this.setValue(this.token, this.convert(value));
            if (this.afterChangeNotifications != null) {
                for (AfterChange afterChange : this.afterChangeNotifications) {
                    afterChange.changed(this);
                }
            }
        }

        public boolean valueEquals(String value) {
            return this.get().equals(this.parseString(value));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{token=" + String.valueOf(this.token) + ", value='" + String.valueOf(this.get()) + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value value = (Value)o;
            return this.token.equals(value.token);
        }

        public int hashCode() {
            return Objects.hash(this.token);
        }

        public static interface AfterChange<C extends AbstractConfig<C>, T, R extends Value<T, R>> {
            public void changed(R var1);
        }
    }

    public record ConfigToken<T>(String path, String key, T defaultValue) {
        @Override
        public String toString() {
            return "ConfigToken{path='" + this.path + "', key='" + this.key + "', defaultValue=" + String.valueOf(this.defaultValue) + "}";
        }
    }

    public record Group(@NotNull String modID, @NotNull String title, int order) {
        @Override
        public String toString() {
            return "Group{title='" + this.title + "', order=" + this.order + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.title.equals(group.title);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.title);
        }
    }

    public class BlockPosValue
    extends Value<BlockPos, BlockPosValue> {
        public BlockPosValue(AbstractConfig this$0, String path, String key, BlockPos defaultValue) {
            super(path, key, defaultValue);
        }

        public BlockPosValue(AbstractConfig this$0, String path, String key, BlockPos defaultValue, boolean isDeprecated) {
            super(path, key, defaultValue, isDeprecated);
        }

        public BlockPosValue(AbstractConfig this$0, ConfigToken token) {
            super(token);
        }

        public BlockPosValue(AbstractConfig this$0, ConfigToken token, boolean isDeprecated) {
            super(token, isDeprecated);
        }

        @Override
        protected BlockPos convert(@NotNull JsonElement el) {
            JsonObject o = el.getAsJsonObject();
            return new BlockPos(o.get("x").getAsInt(), o.get("y").getAsInt(), o.get("z").getAsInt());
        }

        @Override
        @NotNull
        protected JsonElement convert(BlockPos value) {
            JsonObject o = new JsonObject();
            o.addProperty("x", (Number)value.getX());
            o.addProperty("y", (Number)value.getY());
            o.addProperty("z", (Number)value.getZ());
            return o;
        }

        @Override
        @NotNull
        protected BlockPos parseString(@NotNull String value) {
            return this.convert((JsonElement)new Gson().fromJson(value, JsonObject.class));
        }
    }

    public class StringValue
    extends Value<String, StringValue> {
        public StringValue(AbstractConfig this$0, String path, String key, String defaultValue) {
            super(path, key, defaultValue);
        }

        protected StringValue(AbstractConfig this$0, ConfigToken<String> t) {
            super(t);
        }

        public StringValue(AbstractConfig this$0, String path, String key, String defaultValue, boolean isDeprecated) {
            super(path, key, defaultValue, isDeprecated);
        }

        protected StringValue(AbstractConfig this$0, ConfigToken<String> t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected String convert(@NotNull JsonElement el) {
            return el.getAsString();
        }

        @Override
        @NotNull
        protected JsonElement convert(String value) {
            return new JsonPrimitive(value);
        }

        @Override
        @NotNull
        protected String parseString(String value) {
            return value;
        }

        @Override
        public StringValue hideInUI() {
            return (StringValue)super.hideInUI();
        }
    }

    public class BooleanValue
    extends Value<Boolean, BooleanValue> {
        public BooleanValue(String path, String key, boolean defaultValue) {
            super(path, key, defaultValue);
        }

        protected BooleanValue(ConfigToken t) {
            super(t);
        }

        public BooleanValue(String path, String key, boolean defaultValue, boolean isDeprecated) {
            super(path, key, defaultValue, isDeprecated);
        }

        protected BooleanValue(ConfigToken t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected Boolean convert(@NotNull JsonElement el) {
            return el.getAsBoolean();
        }

        @Override
        @NotNull
        protected JsonElement convert(Boolean value) {
            return new JsonPrimitive(value);
        }

        @Override
        @NotNull
        protected Boolean parseString(String value) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        public BooleanValue and(BooleanValue ... condition) {
            BooleanValue res = this.and(() -> Arrays.stream(condition).map(c -> (Boolean)c.get()).reduce(true, (p, c) -> p != false && c != false));
            if (condition.length == 1) {
                res.setDependency(condition[0]);
            }
            return res;
        }

        public BooleanValue and(final Supplier<Boolean> condition) {
            final BooleanValue self = this;
            BooleanValue res = new BooleanValue(this, this.token, this.isDeprecated()){

                @Override
                public Boolean get() {
                    return (Boolean)condition.get() != false && (Boolean)self.get() != false;
                }

                @Override
                public void set(Boolean value) {
                    self.set(value);
                }
            };
            res.isValidSupplier = condition;
            return res;
        }

        public BooleanValue or(BooleanValue ... condition) {
            return this.or(() -> Arrays.stream(condition).map(c -> (Boolean)c.get()).reduce(true, (p, c) -> p != false || c != false));
        }

        public BooleanValue or(final Supplier<Boolean> condition) {
            final BooleanValue self = this;
            BooleanValue res = new BooleanValue(this, this.token, this.isDeprecated()){

                @Override
                public Boolean get() {
                    return (Boolean)condition.get() != false || (Boolean)self.get() != false;
                }

                @Override
                public void set(Boolean value) {
                    self.set(value);
                }
            };
            res.isValidSupplier = condition;
            return res;
        }

        @Override
        public BooleanValue hideInUI() {
            return (BooleanValue)super.hideInUI();
        }
    }

    public class FloatValue
    extends Value<Float, FloatValue> {
        private float min = -3.4028235E38f;
        private float max = Float.MAX_VALUE;

        public FloatValue(AbstractConfig this$0, String path, String key, float defaultValue) {
            super(path, key, Float.valueOf(defaultValue));
        }

        protected FloatValue(AbstractConfig this$0, ConfigToken t) {
            super(t);
        }

        public FloatValue(AbstractConfig this$0, String path, String key, float defaultValue, boolean isDeprecated) {
            super(path, key, Float.valueOf(defaultValue), isDeprecated);
        }

        protected FloatValue(AbstractConfig this$0, ConfigToken t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected Float convert(@NotNull JsonElement el) {
            return Float.valueOf(Math.min(this.max, Math.max(this.min, el.getAsFloat())));
        }

        @Override
        @NotNull
        protected JsonElement convert(Float value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        @NotNull
        protected Float parseString(String value) {
            try {
                return Float.valueOf(Math.min(this.max, Math.max(this.min, Float.parseFloat(value))));
            }
            catch (NumberFormatException ex) {
                return Float.valueOf(Float.NaN);
            }
        }

        @Override
        public FloatValue hideInUI() {
            return (FloatValue)super.hideInUI();
        }

        public FloatValue min(float min) {
            this.min = min;
            return this;
        }

        public FloatValue max(float max) {
            this.max = max;
            return this;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }
    }

    public class IntValue
    extends Value<Integer, IntValue> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public IntValue(AbstractConfig this$0, String path, String key, int defaultValue) {
            super(path, key, defaultValue);
        }

        protected IntValue(AbstractConfig this$0, ConfigToken t) {
            super(t);
        }

        public IntValue(AbstractConfig this$0, String path, String key, int defaultValue, boolean isDeprecated) {
            super(path, key, defaultValue, isDeprecated);
        }

        protected IntValue(AbstractConfig this$0, ConfigToken t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected Integer convert(@NotNull JsonElement el) {
            return Math.min(this.max, Math.max(this.min, el.getAsInt()));
        }

        @Override
        @NotNull
        protected JsonElement convert(Integer value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        @NotNull
        protected Integer parseString(String value) {
            try {
                return Math.min(this.max, Math.max(this.min, Integer.parseInt(value)));
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }

        @Override
        public IntValue hideInUI() {
            return (IntValue)super.hideInUI();
        }

        public IntValue min(int min) {
            this.min = min;
            return this;
        }

        public int getMin() {
            return this.min;
        }

        public IntValue max(int max) {
            this.max = max;
            return this;
        }

        public int getMax() {
            return this.max;
        }

        public int getClamped() {
            return Math.min(this.max, Math.max(this.min, (Integer)this.get()));
        }
    }
}

