/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class MountMedia
implements IMedia {
    public static final IMedia COMPUTER = new MountMedia("computer", ModRegistry.DataComponents.COMPUTER_ID, false, ConfigSpec.computerSpaceLimit);
    public static final IMedia DISK = new MountMedia("disk", ModRegistry.DataComponents.DISK_ID, true, ConfigSpec.floppySpaceLimit);
    private final String subPath;
    private final Supplier<DataComponentType<NonNegativeId>> id;
    private final boolean createId;
    private final Supplier<Integer> defaultCapacity;

    public MountMedia(String subPath, Supplier<DataComponentType<NonNegativeId>> id, boolean createId, Supplier<Integer> defaultCapacity) {
        this.subPath = subPath;
        this.id = id;
        this.createId = createId;
        this.defaultCapacity = defaultCapacity;
    }

    @Override
    public @Nullable String getLabel(HolderLookup.Provider registries, ItemStack stack) {
        return DataComponentUtil.getCustomName((DataComponentHolder)stack);
    }

    @Override
    public boolean setLabel(ItemStack stack, @Nullable String label) {
        DataComponentUtil.setCustomName(stack, label);
        return true;
    }

    @Override
    public @Nullable Mount createDataMount(ItemStack stack, ServerLevel level) {
        int id;
        int n = id = this.createId ? NonNegativeId.getOrCreate(level.getServer(), stack, this.id.get(), this.subPath) : NonNegativeId.getId((NonNegativeId)stack.get(this.id.get()));
        if (id < 0) {
            return null;
        }
        long capacity = StorageCapacity.getOrDefault((StorageCapacity)stack.get((DataComponentType)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), this.defaultCapacity);
        return ComputerCraftAPI.createSaveDirMount(level.getServer(), this.subPath + "/" + id, capacity);
    }
}

